<?php
/* Copyright 2023 Flávio Ribeiro

This file is part of OCOMON.

OCOMON is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

OCOMON is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Foobar; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */ session_start();

if (!isset($_SESSION['s_logado']) || $_SESSION['s_logado'] == 0) {
    $_SESSION['session_expired'] = 1;
    echo "<script>top.window.location = '../../index.php'</script>";
    exit;
}

require_once __DIR__ . "/" . "../../includes/include_geral_new.inc.php";
require_once __DIR__ . "/" . "../../includes/classes/ConnectPDO.php";

use includes\classes\ConnectPDO;

$auth = new AuthNew($_SESSION['s_logado'], $_SESSION['s_nivel'], 1);

$_SESSION['s_page_admin'] = $_SERVER['PHP_SELF'];

$conn = ConnectPDO::getInstance();

$config = getConfig($conn);
$configExt = getConfigValues($conn);

/* Não permitir desativação ou remoção do cliente padrão do sistema */
// $systemClient = [1];

/* Chaves Definidas na tipagem no banco de dados */
$docTypes = array(
    'cnpj' => TRANS('CNPJ'),
    'cpf' => TRANS('CPF'),
    'outro' => TRANS('OTHER')
);

$maskTypes = array(
    'cnpj' => '\d{2}\.\d{3}\.\d{3}\/\d{4}\-\d{2}',
    'cpf' => '\d{3}\-\d{2}',
    'outro' => ''
);


?>
<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" type="text/css" href="../../includes/css/estilos.css" />
    <link rel="stylesheet" type="text/css" href="../../includes/css/my_datatables.css" />
    <link rel="stylesheet" type="text/css" href="../../includes/css/switch_radio.css" />
    <link rel="stylesheet" type="text/css" href="../../includes/components/bootstrap/custom.css" />
    <link rel="stylesheet" type="text/css" href="../../includes/components/fontawesome/css/all.min.css" />
    <link rel="stylesheet" type="text/css" href="../../includes/components/datatables/datatables.min.css" />
    <link rel="stylesheet" type="text/css" href="../../includes/components/bootstrap-select/dist/css/bootstrap-select.min.css" />
	<link rel="stylesheet" type="text/css" href="../../includes/css/my_bootstrap_select.css" />
	<link rel="stylesheet" type="text/css" href="../../includes/css/estilos_custom.css" />

    <title><?= APP_NAME; ?>&nbsp;<?= VERSAO; ?></title>
</head>

<body>


    <div class="container">
        <div id="idLoad" class="loading" style="display:none"></div>
    </div>

    <div id="divResult"></div>

    <div class="container-fluid">
        <h5 class="my-4"><i class="fas fa-id-badge text-secondary"></i>&nbsp;<?= TRANS('CONTRACTORS'); ?></h5>
        <div id="div_flash"></div>
        <div class="modal" id="modal" tabindex="-1" style="z-index:9001!important">
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <div id="divDetails" style="position:relative">
                        <iframe id="iframe-content"  frameborder="1" style="position:absolute;top:0px;width:100%;height:100vh;"></iframe>
                    </div>
                </div>
            </div>
        </div>

        <?php
        if (isset($_SESSION['flash']) && !empty($_SESSION['flash'])) {
            echo $_SESSION['flash'];
            $_SESSION['flash'] = '';
        }

        $contractors = getContractors($conn, (isset($_GET['cod']) ? (int)$_GET['cod'] : null));

        $registros = count($contractors);

        
        if ((!isset($_GET['action'])) && !isset($_POST['submit'])) {

        ?>
            <!-- Modal -->
            <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header bg-light">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-exclamation-triangle text-secondary"></i>&nbsp;<?= TRANS('REMOVE'); ?></h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <?= TRANS('CONFIRM_REMOVE'); ?> <span class="j_param_id"></span>?
                        </div>
                        <div class="modal-footer bg-light">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= TRANS('BT_CANCEL'); ?></button>
                            <button type="button" id="deleteButton" class="btn"><?= TRANS('BT_OK'); ?></button>
                        </div>
                    </div>
                </div>
            </div>

            <button class="btn btn-sm btn-primary" id="idBtIncluir" name="new"><?= TRANS("ACT_NEW"); ?></button><br /><br />
            <?php
            if ($registros == 0) {
                echo message('info', '', TRANS('NO_RECORDS_FOUND'), '', '', true);
            } else {

            ?>
                <table id="table_contractors" class="stripe hover order-column row-border" border="0" cellspacing="0" width="100%">
                    <thead>
                        <tr class="header">
                            <td class="line company_name"><?= TRANS('COL_NAME'); ?></td>
                            <td class="line contact_name"><?= TRANS('CONTACT'); ?></td>
                            <td class="line contact_email"><?= TRANS('CONTACT_EMAIL'); ?></td>
                            <td class="line contact_phone"><?= TRANS('CONTACT_PHONE'); ?></td>
                            <td class="line client_address"><?= TRANS('ADDRESS'); ?></td>
                            <td class="line editar"><?= TRANS('BT_EDIT'); ?></td>
                            <td class="line remover"><?= TRANS('BT_REMOVE'); ?></td>
                        </tr>
                    </thead>
                    <?php
                    $addressKeys = ['addr_street', 'addr_number', 'addr_complement', 'addr_neighborhood', 'addr_cep', 'addr_city', 'addr_uf'];

                    foreach ($contractors as $contractor) {

                        $fullAddress = "";
                        $locationArray = [];
                        foreach ($addressKeys as $key) {
                            $locationArray[] = $contractor[$key];
                        }
                        $fullAddress = implode(" - ", array_filter($locationArray));
                        ?>
                            <tr>
                                <td class="line"><span class="company_name" data-id="<?= $contractor['id']; ?>"><i class="fas fa-eye text-secondary"></i>&nbsp;<?= $contractor['company_name']; ?></span></td>
                                <td class="line"><?= $contractor['contact_name']; ?></td>
                                <td class="line"><?= $contractor['contact_email']; ?></td>
                                <td class="line"><?= $contractor['contact_phone']; ?></td>
                                <td class="line"><?= $fullAddress; ?></td>
                                
                                <td class="line"><button type="button" class="btn btn-secondary btn-sm" onclick="redirect('<?= $_SERVER['PHP_SELF']; ?>?action=edit&cod=<?= $contractor['id']; ?>')"><?= TRANS('BT_EDIT'); ?></button></td>
                                <td class="line"><button type="button" class="btn btn-danger btn-sm" onclick="confirmDeleteModal('<?= $contractor['id']; ?>')"><?= TRANS('REMOVE'); ?></button></td>
                            </tr>
                        <?php
                    }
                    ?>
                    </table>
            <?php
            }
        } else
		if ((isset($_GET['action'])  && ($_GET['action'] == "new")) && !isset($_POST['submit'])) {

            ?>
            <h6><?= TRANS('NEW_RECORD'); ?></h6>
            <form method="post" action="<?= $_SERVER['PHP_SELF']; ?>" id="form">
                <?= csrf_input(); ?>
                <div class="form-group row my-4">

                    <label for="company_name" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('COMPANY_NAME'); ?></label>
                    <div class="form-group col-md-4">
                        <input type="text" class="form-control" id="company_name" name="company_name" required />
                    </div>

                    <label for="contact_name" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('COMPANY_RESPONSIBLE'); ?></label>
                    <div class="form-group col-md-4 ">
                        <input type="text" class="form-control " id="contact_name" name="contact_name" />
                    </div>


                    <label for="contact_email" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('CONTACT_EMAIL'); ?></label>
                    <div class="form-group col-md-4 ">
                        <input type="email" class="form-control " id="contact_email" name="contact_email" />
                    </div>

                    <label for="contact_phone" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('CONTACT_PHONE'); ?></label>
                    <div class="form-group col-md-4 ">
                        <input type="tel" class="form-control " id="contact_phone" name="contact_phone" />
                    </div>

                    <div class="w-100"></div>
                    <label for="doc_type" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('DOCUMENT_TYPE'); ?></label>
                    <div class="form-group col-md-4 ">
                        <select class="form-control" id="doc_type" name="doc_type">
                            <?php
                                foreach ($docTypes as $key => $value) {
                                    ?>
                                        <option value="<?= $key; ?>"><?= $value; ?></option>
                                    <?php
                                }
                            ?>
                        </select>
                    </div>

                    <label for="document_number" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('DOCUMENT_VALUE'); ?></label>
                    <div class="form-group col-md-4 ">
                        <input type="text" class="form-control " id="document_number" name="document_number" />
                    </div>

                    <label for="city_registration" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('CITY_REGISTRATION'); ?></label>
                    <div class="form-group col-md-4 ">
                        <input type="text" class="form-control " id="city_registration" name="city_registration" />
                    </div>

                    <label for="state_registration" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('STATE_REGISTRATION'); ?></label>
                    <div class="form-group col-md-4">
                        <input type="text" class="form-control" id="state_registration" name="state_registration" />
                    </div>

                    <label for="contract_number" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('CONTRACT_NUMBER'); ?></label>
                    <div class="form-group col-md-4">
                        <input type="text" class="form-control" id="contract_number" name="contract_number" />
                    </div>
                    <div class="w-100"></div>
                    <label for="observation" class="col-md-2 col-form-label col-form-label-sm text-md-right" data-toggle="popover" data-placement="top" data-trigger="hover" data-content="<?= TRANS('TXT_INFO_COMPLEM'); ?>"><?= firstLetterUp(TRANS('TXT_INFO_COMPLEM')); ?></label>
					<div class="form-group col-md-10 ">
						<textarea class="form-control" name="observation" id="observation"></textarea>
					</div>

                    <div class="form-group col-md-2">
					</div>
					<div class="form-group col-md-10">
						<hr />
                        <small class="form-text text-muted"><?= TRANS('ADDRESS'); ?></small>
                    </div>

					<label for="unit_cep" class="col-md-2 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('CEP'); ?></label>
					<div class="form-group col-md-3">
						<div class="input-group">
							<input type="text" class="form-control " id="unit_cep" name="unit_cep"  />
							<div class="input-group-append">
								<div class="input-group-text load-address" title="<?= TRANS('GET_ADDRESS_INFO_BY_CEP'); ?>" data-placeholder="<?= TRANS('GET_ADDRESS_INFO_BY_CEP'); ?>" data-toggle="popover" data-placement="top" data-trigger="hover">
									<i class="fas fa-search-location"></i>&nbsp;
								</div>
                        	</div>
						</div>
                    </div>
					<label for="unit_street" class="col-md-1 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('STREET'); ?></label>
					<div class="form-group col-md-6">
						<input type="text" class="form-control " id="unit_street" name="unit_street"  />
                    </div>
					<label for="unit_neighborhood" class="col-md-2 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('NEIGHBORHOOD'); ?></label>
					<div class="form-group col-md-3">
						<input type="text" class="form-control " id="unit_neighborhood" name="unit_neighborhood"  />
                    </div>
					<label for="unit_city" class="col-md-1 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('CITY'); ?></label>
					<div class="form-group col-md-4">
						<input type="text" class="form-control " id="unit_city" name="unit_city"  />
                    </div>
					<label for="unit_state" class="col-md-1 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('ADDRESS_STATE'); ?></label>
					<div class="form-group col-md-1">
						<input type="text" class="form-control " id="unit_state" name="unit_state"  />
                    </div>

					<label for="unit_address_number" class="col-md-2 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('ADDRESS_NUMBER'); ?></label>
					<div class="form-group col-md-3">
						<input type="text" class="form-control " id="unit_address_number" name="unit_address_number"  />
                    </div>
					<label for="unit_address_complement" class="col-md-1 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('ADDRESS_COMPLEMENT'); ?></label>
					<div class="form-group col-md-6">
						<input type="text" class="form-control " id="unit_address_complement" name="unit_address_complement"  />
                    </div>

					<div class="form-group col-md-2">
					</div>
					<div class="form-group col-md-10">
						<hr />
                    </div>

					
                    

                    <label class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= firstLetterUp(TRANS('ACTIVE_O')); ?></label>
					<div class="form-group col-md-4 ">
						<div class="switch-field">
							<?php
							$yesChecked = "checked";
							$noChecked = "";
							?>
							<input type="radio" id="contractor_active" name="contractor_active" value="yes" <?= $yesChecked; ?> />
							<label for="contractor_active"><?= TRANS('YES'); ?></label>
							<input type="radio" id="contractor_active_no" name="contractor_active" value="no" <?= $noChecked; ?> />
							<label for="contractor_active_no"><?= TRANS('NOT'); ?></label>
						</div>
					</div>

                </div>


                <div class="form-group row my-4">
                    <div class="row w-100"></div>
                    <div class="form-group col-md-8 d-none d-md-block">
                    </div>
                    <div class="form-group col-12 col-md-2 ">

                        <input type="hidden" name="cod" value="" id="cod" />
                        <input type="hidden" name="action" id="action" value="new">
                        <button type="submit" id="idSubmit" name="submit" class="btn btn-primary btn-block"><?= TRANS('BT_OK'); ?></button>
                    </div>
                    <div class="form-group col-12 col-md-2">
                        <button type="reset" class="btn btn-secondary btn-block" onClick="parent.history.back();"><?= TRANS('BT_CANCEL'); ?></button>
                    </div>
                </div>
            </form>
        <?php
        } else

		if ((isset($_GET['action']) && $_GET['action'] == "edit") && empty($_POST['submit'])) {
        ?>
            <h6><?= TRANS('BT_EDIT'); ?></h6>
            <form method="post" action="<?= $_SERVER['PHP_SELF']; ?>" id="form">
                <?= csrf_input(); ?>
                
                <div class="form-group row my-4">

                <label for="company_name" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('COMPANY_NAME'); ?></label>
                    <div class="form-group col-md-4">
                        <input type="text" class="form-control" id="company_name" name="company_name" required value="<?= $contractors['company_name']; ?>"/>
                    </div>

                    <label for="contact_name" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('COMPANY_RESPONSIBLE'); ?></label>
                    <div class="form-group col-md-4 ">
                        <input type="text" class="form-control " id="contact_name" name="contact_name" value="<?= $contractors['contact_name']; ?>"/>
                    </div>

                    <label for="contact_email" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('CONTACT_EMAIL'); ?></label>
                    <div class="form-group col-md-4 ">
                        <input type="email" class="form-control " id="contact_email" name="contact_email" value="<?= $contractors['contact_email']; ?>"/>
                    </div>

                    <label for="contact_phone" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('CONTACT_PHONE'); ?></label>
                    <div class="form-group col-md-4 ">
                        <input type="tel" class="form-control " id="contact_phone" name="contact_phone" value="<?= $contractors['contact_phone']; ?>"/>
                    </div>

                    <div class="w-100"></div>
                    <label for="doc_type" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('DOCUMENT_TYPE'); ?></label>
                    <div class="form-group col-md-4 ">
                        <select class="form-control" id="doc_type" name="doc_type">
                            <?php
                                foreach ($docTypes as $key => $value) {
                                    ?>
                                        <option value="<?= $key; ?>"
                                        <?= $key == $contractors['document_type'] ? " selected" : ""; ?>
                                        ><?= $value; ?></option>
                                    <?php
                                }
                            ?>
                        </select>
                    </div>

                    <label for="document_number" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('DOCUMENT_VALUE'); ?></label>
                    <div class="form-group col-md-4 ">
                        <input type="text" class="form-control " id="document_number" name="document_number" value="<?= $contractors['document_value']; ?>"/>
                    </div>

                    <label for="city_registration" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('CITY_REGISTRATION'); ?></label>
                    <div class="form-group col-md-4 ">
                        <input type="text" class="form-control " id="city_registration" name="city_registration" value="<?= $contractors['city_registration']; ?>"/>
                    </div>

                    <label for="state_registration" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('STATE_REGISTRATION'); ?></label>
                    <div class="form-group col-md-4">
                        <input type="text" class="form-control" id="state_registration" name="state_registration" value="<?= $contractors['state_registration']; ?>"/>
                    </div>

                    <label for="contract_number" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('CONTRACT_NUMBER'); ?></label>
                    <div class="form-group col-md-4">
                        <input type="text" class="form-control" id="contract_number" name="contract_number" value="<?= $contractors['contract_number']; ?>"/>
                    </div>
                    <div class="w-100"></div>
                    <label for="observation" class="col-md-2 col-form-label col-form-label-sm text-md-right" data-toggle="popover" data-placement="top" data-trigger="hover" data-content="<?= TRANS('TXT_INFO_COMPLEM'); ?>"><?= firstLetterUp(TRANS('TXT_INFO_COMPLEM')); ?></label>
					<div class="form-group col-md-10 ">
						<textarea class="form-control" name="observation" id="observation"><?= $contractors['observation']; ?></textarea>
					</div>

                    <div class="form-group col-md-2">
					</div>
					<div class="form-group col-md-10">
						<hr />
                        <small class="form-text text-muted"><?= TRANS('ADDRESS'); ?></small>
                    </div>

					<label for="unit_cep" class="col-md-2 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('CEP'); ?></label>
					<div class="form-group col-md-3">
						<div class="input-group">
							<input type="text" class="form-control " id="unit_cep" name="unit_cep" value="<?= $contractors['addr_cep']; ?>"/>
							<div class="input-group-append">
								<div class="input-group-text load-address" title="<?= TRANS('GET_ADDRESS_INFO_BY_CEP'); ?>" data-placeholder="<?= TRANS('GET_ADDRESS_INFO_BY_CEP'); ?>" data-toggle="popover" data-placement="top" data-trigger="hover">
									<i class="fas fa-search-location"></i>&nbsp;
								</div>
                        	</div>
						</div>
                    </div>
					<label for="unit_street" class="col-md-1 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('STREET'); ?></label>
					<div class="form-group col-md-6">
						<input type="text" class="form-control " id="unit_street" name="unit_street" value="<?= $contractors['addr_street']; ?>"/>
                    </div>
					<label for="unit_neighborhood" class="col-md-2 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('NEIGHBORHOOD'); ?></label>
					<div class="form-group col-md-3">
						<input type="text" class="form-control " id="unit_neighborhood" name="unit_neighborhood"  value="<?= $contractors['addr_neighborhood']; ?>"/>
                    </div>
					<label for="unit_city" class="col-md-1 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('CITY'); ?></label>
					<div class="form-group col-md-4">
						<input type="text" class="form-control " id="unit_city" name="unit_city" value="<?= $contractors['addr_city']; ?>"  />
                    </div>
					<label for="unit_state" class="col-md-1 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('ADDRESS_STATE'); ?></label>
					<div class="form-group col-md-1">
						<input type="text" class="form-control " id="unit_state" name="unit_state" value="<?= $contractors['addr_uf']; ?>" />
                    </div>

					<label for="unit_address_number" class="col-md-2 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('ADDRESS_NUMBER'); ?></label>
					<div class="form-group col-md-3">
						<input type="text" class="form-control " id="unit_address_number" name="unit_address_number" value="<?= $contractors['addr_number']; ?>" />
                    </div>
					<label for="unit_address_complement" class="col-md-1 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('ADDRESS_COMPLEMENT'); ?></label>
					<div class="form-group col-md-6">
						<input type="text" class="form-control " id="unit_address_complement" name="unit_address_complement" value="<?= $contractors['addr_complement']; ?>" />
                    </div>

					<div class="form-group col-md-2">
					</div>
					<div class="form-group col-md-10">
						<hr />
                    </div>
                    

                    <label class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= firstLetterUp(TRANS('ACTIVE_O')); ?></label>
					<div class="form-group col-md-4 ">
						<div class="switch-field">
							<?php
							$yesChecked = ($contractors['active'] == 1 ? "checked" : "");
							$noChecked = (!($contractors['active'] == 1) ? "checked" : "");
							?>
							<input type="radio" id="contractor_active" name="contractor_active" value="yes" <?= $yesChecked; ?> />
							<label for="contractor_active"><?= TRANS('YES'); ?></label>
							<input type="radio" id="contractor_active_no" name="contractor_active" value="no" <?= $noChecked; ?> />
							<label for="contractor_active_no"><?= TRANS('NOT'); ?></label>
						</div>
					</div>

                </div>

                
                <div class="form-group row my-4">

                    <input type="hidden" name="cod" id="cod" value="<?= $_GET['cod']; ?>">
                    <input type="hidden" name="action" id="action" value="edit">

                    <div class="row w-100"></div>
                    <div class="form-group col-md-8 d-none d-md-block">
                    </div>
                    <div class="form-group col-12 col-md-2 ">
                        <button type="submit" id="idSubmit" name="submit" value="edit" class="btn btn-primary btn-block"><?= TRANS('BT_OK'); ?></button>
                    </div>
                    <div class="form-group col-12 col-md-2">
                        <button type="reset" class="btn btn-secondary btn-block" onClick="parent.history.back();"><?= TRANS('BT_CANCEL'); ?></button>
                    </div>

                </div>
            </form>
        <?php
        } elseif ((isset($_GET['action']) && $_GET['action'] == "view") && empty($_POST['submit'])) {

            ?>
                    <div class="form-group row my-4">
                        

                        <label for="actions" class="col-md-2 col-form-label col-form-label-sm text-md-right"></label>
                        <div class="form-group col-md-10">
                            <button type="button" class="btn btn-secondary btn-sm" onclick="redirect('<?= $_SERVER['PHP_SELF']; ?>?action=edit&cod=<?= $contractors['id']; ?>')"><i class="fas fa-edit"></i>&nbsp;<?= TRANS('BT_EDIT'); ?></button>
                            <button type="button" class="btn btn-secondary btn-sm" onclick="popup_wide('./generate_invoice.php?contractor=<?= $contractors['id'];?>')"><i class="fas fa-file-invoice"></i>&nbsp;<?= TRANS('INVOICES'); ?></button>
                        </div>
    
                        <label for="company_name" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('COMPANY_NAME'); ?></label>
                        <div class="form-group col-md-4">
                            <input type="text" class="form-control" id="company_name" name="company_name" disabled value="<?= $contractors['company_name']; ?>"/>
                        </div>
    
                        <label for="contact_name" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('COMPANY_RESPONSIBLE'); ?></label>
                        <div class="form-group col-md-4 ">
                            <input type="text" class="form-control " id="contact_name" name="contact_name" disabled value="<?= $contractors['contact_name']; ?>"/>
                        </div>
    
                        <label for="contact_email" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('CONTACT_EMAIL'); ?></label>
                        <div class="form-group col-md-4 ">
                            <input type="email" class="form-control " id="contact_email" name="contact_email" value="<?= $contractors['contact_email']; ?>" disabled/>
                        </div>
    
                        <label for="contact_phone" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('CONTACT_PHONE'); ?></label>
                        <div class="form-group col-md-4 ">
                            <input type="tel" class="form-control " id="contact_phone" name="contact_phone" value="<?= $contractors['contact_phone']; ?>" disabled/>
                        </div>
    
                        <div class="w-100"></div>
                        <label for="doc_type" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('DOCUMENT_TYPE'); ?></label>
                        <div class="form-group col-md-4 ">
                            <select class="form-control" id="doc_type" name="doc_type" disabled>
                                <?php
                                    foreach ($docTypes as $key => $value) {
                                        ?>
                                            <option value="<?= $key; ?>"
                                            <?= $key == $contractors['document_type'] ? " selected" : ""; ?>
                                            ><?= $value; ?></option>
                                        <?php
                                    }
                                ?>
                            </select>
                        </div>
    
                        <label for="document_number" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('DOCUMENT_VALUE'); ?></label>
                        <div class="form-group col-md-4 ">
                            <input type="text" class="form-control " id="document_number" name="document_number" value="<?= $contractors['document_value']; ?>" disabled/>
                        </div>
    
                        <label for="city_registration" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('CITY_REGISTRATION'); ?></label>
                        <div class="form-group col-md-4 ">
                            <input type="text" class="form-control " id="city_registration" name="city_registration" value="<?= $contractors['city_registration']; ?>" disabled/>
                        </div>
    
                        <label for="state_registration" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('STATE_REGISTRATION'); ?></label>
                        <div class="form-group col-md-4">
                            <input type="text" class="form-control" id="state_registration" name="state_registration" value="<?= $contractors['state_registration']; ?>" disabled/>
                        </div>
    
                        <label for="contract_number" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('CONTRACT_NUMBER'); ?></label>
                        <div class="form-group col-md-4">
                            <input type="text" class="form-control" id="contract_number" name="contract_number" value="<?= $contractors['contract_number']; ?>" disabled/>
                        </div>
                        <div class="w-100"></div>
                        <label for="observation" class="col-md-2 col-form-label col-form-label-sm text-md-right" data-toggle="popover" data-placement="top" data-trigger="hover" data-content="<?= TRANS('TXT_INFO_COMPLEM'); ?>"><?= firstLetterUp(TRANS('TXT_INFO_COMPLEM')); ?></label>
                        <div class="form-group col-md-10 ">
                            <textarea class="form-control" name="observation" id="observation" disabled><?= $contractors['observation']; ?></textarea>
                        </div>
    
                        <div class="form-group col-md-2">
                        </div>
                        <div class="form-group col-md-10">
                            <hr />
                            <small class="form-text text-muted"><?= TRANS('ADDRESS'); ?></small>
                        </div>
    
                        <label for="unit_cep_view" class="col-md-2 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('CEP'); ?></label>
                        <div class="form-group col-md-3">
                            <input type="text" class="form-control " id="unit_cep_view" name="unit_cep_view" value="<?= $contractors['addr_cep']; ?>" disabled/>
                        </div>
                        <label for="unit_street" class="col-md-1 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('STREET'); ?></label>
                        <div class="form-group col-md-6">
                            <input type="text" class="form-control " id="unit_street" name="unit_street" value="<?= $contractors['addr_street']; ?>" disabled/>
                        </div>
                        <label for="unit_neighborhood" class="col-md-2 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('NEIGHBORHOOD'); ?></label>
                        <div class="form-group col-md-3">
                            <input type="text" class="form-control " id="unit_neighborhood" name="unit_neighborhood"  value="<?= $contractors['addr_neighborhood']; ?>" disabled/>
                        </div>
                        <label for="unit_city" class="col-md-1 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('CITY'); ?></label>
                        <div class="form-group col-md-4">
                            <input type="text" class="form-control " id="unit_city" name="unit_city" value="<?= $contractors['addr_city']; ?>"  disabled/>
                        </div>
                        <label for="unit_state" class="col-md-1 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('ADDRESS_STATE'); ?></label>
                        <div class="form-group col-md-1">
                            <input type="text" class="form-control " id="unit_state" name="unit_state" value="<?= $contractors['addr_uf']; ?>" disabled/>
                        </div>
    
                        <label for="unit_address_number" class="col-md-2 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('ADDRESS_NUMBER'); ?></label>
                        <div class="form-group col-md-3">
                            <input type="text" class="form-control " id="unit_address_number" name="unit_address_number" value="<?= $contractors['addr_number']; ?>" disabled/>
                        </div>
                        <label for="unit_address_complement" class="col-md-1 col-form-label col-form-label-sm text-md-right address-info"><?= TRANS('ADDRESS_COMPLEMENT'); ?></label>
                        <div class="form-group col-md-6">
                            <input type="text" class="form-control " id="unit_address_complement" name="unit_address_complement" value="<?= $contractors['addr_complement']; ?>" disabled/>
                        </div>
    
                        <div class="form-group col-md-2">
                        </div>
                        <div class="form-group col-md-10">
                            <hr />
                        </div>
                        
    
                        <label class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= firstLetterUp(TRANS('ACTIVE_O')); ?></label>
                        <div class="form-group col-md-4 ">
                            <div class="switch-field">
                                <?php
                                $yesChecked = ($contractors['active'] == 1 ? "checked" : "");
                                $noChecked = (!($contractors['active'] == 1) ? "checked" : "");
                                ?>
                                <input type="radio" id="contractor_active" name="contractor_active" value="yes" <?= $yesChecked; ?> disabled/>
                                <label for="contractor_active"><?= TRANS('YES'); ?></label>
                                <input type="radio" id="contractor_active_no" name="contractor_active" value="no" <?= $noChecked; ?> disabled/>
                                <label for="contractor_active_no"><?= TRANS('NOT'); ?></label>
                            </div>
                        </div>
    
                    </div>
    
                    
                    <div class="form-group row my-4">
    
                        <input type="hidden" name="cod" id="cod" value="<?= $_GET['cod']; ?>">
                        <input type="hidden" name="action" id="action" value="edit">
    
                        <div class="row w-100"></div>
                        <div class="form-group col-md-8 d-none d-md-block">
                        </div>
                        <div class="form-group col-12 col-md-2 ">
                        </div>
                        <div class="form-group col-12 col-md-2">
                            <button type="reset" class="btn btn-secondary btn-block" onClick="parent.history.back();"><?= TRANS('BT_RETURN'); ?></button>
                        </div>
    
                    </div>
            <?php
            } 
        ?>
    </div>

    <script src="../../includes/javascript/funcoes-3.0.js"></script>
    <script src="../../includes/components/jquery/jquery.js"></script>
    <script src="../../includes/components/bootstrap/js/bootstrap.bundle.js"></script>
    <script src="../../includes/components/bootstrap-select/dist/js/bootstrap-select.min.js"></script>
    <script type="text/javascript" charset="utf8" src="../../includes/components/datatables/datatables.js"></script>
    <script src="../../includes/components/Inputmask-5.x/dist/jquery.inputmask.min.js"></script>
	<script src="../../includes/components/Inputmask-5.x/dist/bindings/inputmask.binding.js"></script>

    <script type="text/javascript">
        $(function() {

            $(function() {
                $('[data-toggle="popover"]').popover({
                    html: true
                });
            });

            $('.popover-dismiss').popover({
                trigger: 'focus'
            });

            maskDynamically('doc_type');
            $('#doc_type').on('change', function() {
                maskDynamically('doc_type');
            });

            $('#unit_cep').inputmask({ mask: '99999-999' }).on('change', function(e){
				e.preventDefault();
				loadAddressData();
			});

			$('.load-address').css('cursor', 'pointer').on('click', function(e) {
				e.preventDefault();
				loadAddressData();
			});

            $('.company_name').css('cursor', 'pointer').on('click', function(e) {
                e.preventDefault();
                let company_id = $(this).attr('data-id');
                redirect('./contractors.php?action=view&cod=' + company_id);
            });

            $.fn.selectpicker.Constructor.BootstrapVersion = '4';
            $('.bs-select').selectpicker({
				/* placeholder */
				title: "<?= TRANS('SEL_SELECT', '', 1); ?>",
				liveSearch: true,
                showSubtext: true,
				liveSearchNormalize: true,
				liveSearchPlaceholder: "<?= TRANS('BT_SEARCH', '', 1); ?>",
				noneResultsText: "<?= TRANS('NO_RECORDS_FOUND', '', 1); ?> {0}",
				style: "",
				styleBase: "form-control ",
			});


            $('#table_contractors').DataTable({
				paging: true,
				deferRender: true,
				// order: [0, 'DESC'],
				columnDefs: [{
					searchable: false,
					orderable: false,
					targets: ['editar', 'remover']
				}],
				"language": {
					"url": "../../includes/components/datatables/datatables.pt-br.json"
				}
			});

            $('#modal').on('hidden.bs.modal', function (e) {
                $("#iframe-content").attr('src','');
            })

            $('.manage_popups').css('cursor', 'pointer').on('click', function() {
				var params = $(this).attr('data-params');
				var location = $(this).attr('data-location');
				loadInIframe(location, params);
			});

            $('input, select, textarea').on('change', function() {
                $(this).removeClass('is-invalid');
            });

            $('#idSubmit').on('click', function(e) {
                e.preventDefault();
                var loading = $(".loading");
                $(document).ajaxStart(function() {
                    loading.show();
                });
                $(document).ajaxStop(function() {
                    loading.hide();
                });


                $("#idSubmit").prop("disabled", true);
                $.ajax({
                    url: './contractors_process.php',
                    method: 'POST',
                    data: $('#form').serialize(),
                    dataType: 'json',
                }).done(function(response) {

                    // console.log(response);
                    if (!response.success) {
                        $('#divResult').html(response.message);
                        $('input, select, textarea').removeClass('is-invalid');
                        if (response.field_id != "") {
                            $('#' + response.field_id).focus().addClass('is-invalid');
                        }
                        $("#idSubmit").prop("disabled", false);
                    } else {
                        $('#divResult').html('');
                        $('input, select, textarea').removeClass('is-invalid');
                        $("#idSubmit").prop("disabled", false);

                        var url = '<?= $_SERVER['PHP_SELF'] ?>';

                        $(location).prop('href', url);
                        return false;
                    }
                });
                return false;
            });



            $('#idBtIncluir').on("click", function() {
                $('#idLoad').css('display', 'block');
                var url = '<?= $_SERVER['PHP_SELF'] ?>?action=new';
                $(location).prop('href', url);
            });

            $('#bt-cancel').on('click', function() {
                var url = '<?= $_SERVER['PHP_SELF'] ?>';
                $(location).prop('href', url);
            });


        }); /* Final do Listener */


        function maskDynamically(el) {
            var doc_type = $('#'+el).val();
            if (doc_type == 'cpf') {
                $('#document_number').inputmask({
                    mask: ['999.999.999-99'],
                    keepStatic: true
                });
            } else if (doc_type == 'cnpj') {
                $('#document_number').inputmask({
                    mask: ['99.999.999/9999-99'],
                    keepStatic: true
                });
            } else {
                $('#document_number').inputmask({
                    mask: null,
                    keepStatic: true
                });
            }
        }

        function loadAddressData() {
			// e.preventDefault();
			var loading = $(".loading");
			$(document).ajaxStart(function() {
				loading.show();
			});
			$(document).ajaxStop(function() {
				loading.hide();
			});

			$(".address-info").each(function() {
				$(this).prop("disabled", true);
			});
			$.ajax({
				url: './get_address_by_cep.php',
				method: 'POST',
				data: {
					cep: $('#unit_cep').val(),
				},
				dataType: 'json',
			}).done(function(response) {

				if (!response.success) {
					$('#divResult').html(response.message);
					$('input, select, textarea').removeClass('is-invalid');
					if (response.field_id != "") {
						$('#' + response.field_id).focus().addClass('is-invalid');
					}
					$(".address-info").each(function() {
						$(this).prop("disabled", false);
					});
				} else {

					$('#divResult').html('');
					$(".address-info").each(function() {
						$(this).prop("disabled", false);
					});
					$('input, select, textarea').removeClass('is-invalid');
					
					$('#unit_street').val(response[0].street);
					$('#unit_neighborhood').val(response[0].neighborhood);
					$('#unit_city').val(response[0].city);
					$('#unit_state').val(response[0].state);

					return false;
				}
			});
			return false;
		};


        function confirmDeleteModal(id) {
            $('#deleteModal').modal();
            $('#deleteButton').html('<a class="btn btn-danger" onclick="deleteData(' + id + ')"><?= TRANS('REMOVE'); ?></a>');
        }

        function deleteData(id) {

            var loading = $(".loading");
            $(document).ajaxStart(function() {
                loading.show();
            });
            $(document).ajaxStop(function() {
                loading.hide();
            });

            $.ajax({
                url: './contractors_process.php',
                method: 'POST',
                data: {
                    cod: id,
                    action: 'delete'
                },
                dataType: 'json',
            }).done(function(response) {
                var url = '<?= $_SERVER['PHP_SELF'] ?>';
                $(location).prop('href', url);
                return false;
            });
            return false;
            // $('#deleteModal').modal('hide'); // now close modal
        }

        function loadInPopup(pageBase, params) {
			let url = pageBase + '.php?' + params;
			x = window.open(url, '', 'dependent=yes,width=800,scrollbars=yes,statusbar=no,resizable=yes');
			x.moveTo(window.parent.screenX + 100, window.parent.screenY + 100);
		}


        function getFlashMessage() {
            $.ajax({
                url: './get_flash_message.php',
                method: 'POST',
            }).done(function(response) {
                if (response.length > 0) {
                    $('#div_flash').html(response);
                }
            })
        }


        function popup_wide(pagina) { //Exibe uma janela popUP
            x = window.open(pagina, '_blank', 'dependent=yes,width=1024,height=768,scrollbars=yes,statusbar=no,resizable=yes');
            x.moveTo(window.parent.screenX + 50, window.parent.screenY + 50);
            return false
        }

        function loadInIframe(pageBase, params) {
            let url = pageBase + '.php?' + params;
            $("#iframe-content").attr('src',url)
            $('#modal').modal();
        }

        function closeIframe() {
            $('#modal').modal('hide');
            $("#iframe-content").attr('src','');
            getFlashMessage();
        }


    </script>
</body>

</html>