<?php session_start();
/*      Copyright 2023 Flávio Ribeiro

        This file is part of OCOMON.

        OCOMON is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 3 of the License, or
        (at your option) any later version.
        OCOMON is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with Foobar; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
require_once (__DIR__ . "/" . "../../includes/include_basics_only.php");
require_once (__DIR__ . "/" . "../../includes/classes/ConnectPDO.php");
use includes\classes\ConnectPDO;

if ($_SESSION['s_logado'] != 1 || ($_SESSION['s_nivel'] != 1)) {
    return;
}

$conn = ConnectPDO::getInstance();

$post = $_POST;
$data = [];

$data['random'] = (isset($post['random']) ? noHtml($post['random']) : "");
$afterDomClass = "after-dom-ready";
$randomClass = $data['random'];

$varsToNotRender = [
    'tabela_de_ativos'
];

$data['template'] = (isset($post['template']) && !empty($post['template']) ? (int)$post['template'] : null);
$data['number_of_recipients'] = (isset($post['number_of_recipients']) && !empty($post['number_of_recipients']) ? (int)$post['number_of_recipients'] : 0);


if (empty($data['template'])) {
    echo message('warning', 'Ooops!', TRANS('MSG_SELECT_TEMPLATE'),'');
    return false;
}


$templateInfo = getMailTemplates($conn, $data['template']);
if (empty($templateInfo)) {
    echo message('warning', 'Ooops!', TRANS('MSG_SELECT_TEMPLATE'), '');
    return false;
}


if ($data['number_of_recipients'] < 1) {
    echo message('warning', 'Ooops!', TRANS('MSG_SELECT_AMOUNT_OF_RECIPIENTS'), '');
    return false;
}

$htmlToParse = $templateInfo['tpl_msg_html'];
// Expressão regular para encontrar todas as variáveis (sem espaço) entre "%"
preg_match_all('/%([^%\s]+)%/', $htmlToParse, $matches);
// O array com as variáveis encontradas
$templateVars = array_unique($matches[1]);


$users = getUsers($conn);


$html = "";

$html .= csrf_input();


for ($i = 0; $i < $data['number_of_recipients']; $i++) {
    
    $html .= '<div class="form-group row my-4 row-card">';
        
        $html .= '<div class="card-title">'.($i+1).'.</div>';

        $html .= '<div class="form-group col-md-3" >
                    <select name="user[]" id="user_' . $i . '" class="form-control bs-select selected-user ' . $afterDomClass . '"/>';

         $html .= '<option value="" selected>'.TRANS('SEL_SELECT').'</option>';
        foreach ($users as $user) {
            $html .= '<option data-subtext="' . $user['email'] . '" data-email="' . $user['email'] . '" data-name="' . $user['nome'] . '" value="' . $user['user_id'] . '">' . $user['nome'] . '</option>';
        }

        $html .= '</select>
                    <small class="form-text text-muted">'.TRANS('FIELD_USER').'</small>
                </div>';
    
        $html .= '<div class="form-group col-md-3" >
                    <input type="text" name="business_email[]" id="business_email_' . $i . '" class="form-control business-email ' . $afterDomClass . '" autocomplete="off" />
                    <small class="form-text text-muted">'.TRANS('BUSINESS_EMAIL').'</small>
                </div>';
        
        $html .= '<div class="form-group col-md-3" >
                <input type="text" name="personal_email[]" id="personal_email_' . $i . '" class="form-control ' . $afterDomClass . '" />
                <small class="form-text text-muted">'.TRANS('PERSONAL_EMAIL').'</small>
            </div>';


        
        
        
        foreach ($templateVars as $key => $col) {

            if (in_array($col, $varsToNotRender)) {
                continue;
            }
            
            $html .= '<div class="form-group col-md-3" >
                <input type="text" name="'.$col.'[]" id="'.$col . '_' . $i . '" class="form-control ' . $afterDomClass . '"/>
                <small class="form-text text-muted">'.$col.'</small>
            </div>';

        }

        /* id="idInputFile'.$i.'" aria-describedby="inputGroupFileAddon01" */
        $html .= '<div class="form-group col-md-4" >
                    <div class="field_wrapper" id="field_wrapper">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <div class="input-group-text">
                                    <a href="javascript:void(0);" class="add_button" id="add_button_'.$i.'" title='. TRANS('TO_ATTACH_ANOTHER') .'"><i class="fa fa-plus"></i></a>
                                </div>
                            </div>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" name="anexo_'.$i.'[]" lang="br">
                                <label class="custom-file-label text-truncate">'.TRANS('CHOOSE_FILE').'</label>
                            </div>
                        </div>
                    </div>
                </div>';

        $html .= '<div class="row w-100"></div><div class="form-group col-md-6" >
                <input type="text" name="copy_to[]" id="copy_to_' . $i . '" class="form-control ' . $afterDomClass . '" />
                <small class="form-text text-muted">'.TRANS('CC_FIELD_TO').'</small>
            </div>';

    $html .= '</div>';

}

$html .= '<div class="form-group row my-4">';
$html .= '<div class="row w-100"></div>
        <div class="form-group col-md-6 d-none d-md-block"></div>
        <div class="form-group col-12 col-md-4 ">
            <input type="hidden" name="action" value="process-messages">
            <button type="submit" id="process-messages" name="process-messages" class="btn btn-primary btn-block"><i class="fa fa-paper-plane"></i>&nbsp;'.TRANS('SEND_EMAILS').'</button>
        </div>
        <div class="form-group col-12 col-md-2">
            <button type="reset" class="btn btn-secondary btn-block" onClick="parent.history.back();">'.TRANS('BT_CANCEL').'</button>
        </div>';
$html .= '</div>';

echo $html;
return true;