<?php
/* Copyright 2023 Flávio Ribeiro

This file is part of OCOMON.

OCOMON is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

OCOMON is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Foobar; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */ session_start();

if (!isset($_SESSION['s_logado']) || $_SESSION['s_logado'] == 0) {
	$_SESSION['session_expired'] = 1;
    echo "<script>top.window.location = '../../index.php'</script>";
	exit;
}

require_once __DIR__ . "/" . "../../includes/include_geral_new.inc.php";
require_once __DIR__ . "/" . "../../includes/classes/ConnectPDO.php";

use includes\classes\ConnectPDO;

$conn = ConnectPDO::getInstance();

$auth = new AuthNew($_SESSION['s_logado'], $_SESSION['s_nivel'], 1);

$_SESSION['s_page_admin'] = $_SERVER['PHP_SELF'];

?>
<!DOCTYPE html>
<html lang="pt-BR">

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" type="text/css" href="../../includes/css/estilos.css" />
    <link rel="stylesheet" type="text/css" href="../../includes/css/switch_radio.css" />
	<link rel="stylesheet" type="text/css" href="../../includes/components/bootstrap/custom.css" />
	<link rel="stylesheet" type="text/css" href="../../includes/components/fontawesome/css/all.min.css" />
	<link rel="stylesheet" type="text/css" href="../../includes/components/datatables/datatables.min.css" />
	<link rel="stylesheet" type="text/css" href="../../includes/css/my_datatables.css" />
	<link rel="stylesheet" type="text/css" href="../../includes/css/estilos_custom.css" />

	<title><?= APP_NAME; ?>&nbsp;<?= VERSAO; ?></title>
</head>

<body>
	
	<div class="container">
		<div id="idLoad" class="loading" style="display:none"></div>
	</div>

	<div id="divResult"></div>


	<div class="container-fluid">
		<h4 class="my-4"><i class="fas fa-angle-double-down text-secondary"></i>&nbsp;<?= TRANS('ADM_PRIORIDADES_ATEND'); ?></h4>
		<div class="modal" id="modal" tabindex="-1" style="z-index:9001!important">
			<div class="modal-dialog modal-xl">
				<div class="modal-content">
					<div id="divDetails">
					</div>
				</div>
			</div>
		</div>

		<?php
		if (isset($_SESSION['flash']) && !empty($_SESSION['flash'])) {
			echo $_SESSION['flash'];
			$_SESSION['flash'] = '';
		}

        $usedLevels = "";
        $sqlGetUsedLevels = "SELECT pr_nivel FROM prior_atend ";
        if (isset($_GET['cod'])) {
			$sqlGetUsedLevels.= " WHERE pr_cod <> ".(int)$_GET['cod']." ";
		}
        $res = $conn->query($sqlGetUsedLevels);
        foreach ($res->fetchall() as $rowUsedLevels) {
            if (strlen((string)$usedLevels) > 0)
                $usedLevels .= ",";
            $usedLevels .= $rowUsedLevels['pr_nivel'];
        }


        $query = "SELECT a.*, p.* FROM prior_atend a, prior_nivel p WHERE a.pr_nivel = p.prn_cod ";
		if (isset($_GET['cod'])) {
			$query.= " AND a.pr_cod = ".(int)$_GET['cod']." ";
		}
		$query .=" ORDER  BY pr_nivel";
		$resultado = $conn->query($query);
		$registros = $resultado->rowCount();

		if ((!isset($_GET['action'])) && !isset($_POST['submit'])) {

		?>
			<!-- Modal -->
			<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content">
						<div class="modal-header bg-light">
							<h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-exclamation-triangle text-secondary"></i>&nbsp;<?= TRANS('REMOVE'); ?></h5>
							<button type="button" class="close" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body">
							<?= TRANS('CONFIRM_REMOVE'); ?> <span class="j_param_id"></span>?
						</div>
						<div class="modal-footer bg-light">
							<button type="button" class="btn btn-secondary" data-dismiss="modal"><?= TRANS('BT_CANCEL'); ?></button>
							<button type="button" id="deleteButton" class="btn"><?= TRANS('BT_OK'); ?></button>
						</div>
					</div>
				</div>
			</div>

			<button class="btn btn-sm btn-primary" id="idBtIncluir" name="new"><?= TRANS("ACT_NEW"); ?></button><br /><br />
			<?php
			if ($registros == 0) {
				echo message('info', '', TRANS('NO_RECORDS_FOUND'), '', '', true);
			} else {

			?>
				<table id="table_lists" class="stripe hover order-column row-border" border="0" cellspacing="0" width="100%">

					<thead>
						<tr class="header">
							<td class="line level"><?= TRANS('LEVEL'); ?></td>
							<td class="line description"><?= TRANS('COL_NAME'); ?></td>
							<td class="line color"><?= TRANS('COL_BG_COLOR'); ?></td>
							<td class="line color"><?= TRANS('FONT_COLOR'); ?></td>
							<td class="line example"><?= TRANS('APPEARANCE'); ?></td>
							<td class="line editar" width="10%"><?= TRANS('BT_EDIT'); ?></td>
							<td class="line remover" width="10%"><?= TRANS('BT_REMOVE'); ?></td>
						</tr>
					</thead>
					<tbody>
						<?php

						foreach ($resultado->fetchall() as $row) {
							$is_default = ($row['pr_default'] ? ' <span class="badge badge-primary p-2">' . TRANS("COL_DEFAULT") . '</span>' : '');
						    ?>
							<tr>
								<td class="line">#<?= $row['pr_nivel'] . $is_default ?></td>
								<td class="line"><?= $row['pr_desc']; ?></td>
								<td class="line"><span class="badge" style="border: 1px solid gray; background: <?= $row['pr_color']; ?>">&nbsp;&nbsp;&nbsp;</span></td>
								<td class="line"><span class="badge" style="border: 1px solid gray; background: <?= $row['pr_font_color']; ?>">&nbsp;&nbsp;&nbsp;</span></td>
								<td class="line"><span class="btn btn-sm cursor-no-event" style="background: <?= $row['pr_color']; ?>; color: <?= $row['pr_font_color']; ?>"><?= $row['pr_desc']; ?></span></td>
								<td class="line"><button type="button" class="btn btn-secondary btn-sm" onclick="redirect('<?= $_SERVER['PHP_SELF']; ?>?action=edit&cod=<?= $row['pr_cod']; ?>')"><?= TRANS('BT_EDIT'); ?></button></td>
								<td class="line"><button type="button" class="btn btn-danger btn-sm" onclick="confirmDeleteModal('<?= $row['pr_cod']; ?>')"><?= TRANS('REMOVE'); ?></button></td>
							</tr>

						    <?php
						}
						?>
					</tbody>
				</table>
			<?php
			}
		} else
		if ((isset($_GET['action'])  && ($_GET['action'] == "new")) && !isset($_POST['submit'])) {

			?>
			<h6><?= TRANS('NEW_RECORD'); ?></h6>
			<form method="post" action="<?= $_SERVER['PHP_SELF']; ?>" id="form">
				<?= csrf_input(); ?>
				<div class="form-group row my-4">
					<label for="level_name" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('COL_NAME'); ?></label>
					<div class="form-group col-md-10">
						<input type="text" class="form-control " id="level_name" name="level_name" required />
					</div>

					<label for="level" class="col-md-2 col-form-label text-md-right"><?= TRANS('LEVEL'); ?></label>
					<div class="form-group col-md-10">
						<select class="form-control " id="level" name="level" >
							<option value=""><?= TRANS('SEL_SELECT'); ?></option>
							<?php
							$sql = "SELECT * FROM prior_nivel WHERE prn_cod NOT IN ({$usedLevels}) ORDER BY prn_level";
							$commit = $conn->query($sql);
							foreach ($commit->fetchAll() as $row) {
								print "<option value=" . $row['prn_cod'] . ">" . $row["prn_level"] . "</option>";
							}
							?>
						</select>
						<small class="text-muted"><?= TRANS('HELPER_LEVEL_ORDER'); ?></small>
                    </div>
                    <label for="priority_color" class="col-md-2 col-form-label text-md-right"><?= TRANS('COL_BG_COLOR'); ?></label>
					<div class="form-group col-md-10">
						<input type="color" class="form-control " id="priority_color" name="priority_color" value="#DDDDDD" required />
                    </div>

					<label for="priority_font_color" class="col-md-2 col-form-label text-md-right"><?= TRANS('FONT_COLOR'); ?></label>
					<div class="form-group col-md-10">
						<input type="color" class="form-control " id="priority_font_color" name="priority_font_color" value="#000000" required />
                    </div>

					<label for="sample" class="col-md-2 col-form-label text-md-right"><?= TRANS('APPEARANCE'); ?></label>
					<div class="form-group col-md-10">
						<span class="btn btn-sm cursor-no-event" style="color: #000000; background-color: #CCCCCC" id="appearance"><?= TRANS('SAMPLE'); ?></span>
                    </div>
                    
                    <label class="col-md-2 col-form-label text-md-right" data-toggle="popover" data-placement="top" data-trigger="hover" data-content="<?= TRANS('COL_DEFAULT'); ?>"><?= firstLetterUp(TRANS('COL_DEFAULT')); ?></label>
					<div class="form-group col-md-4 ">
						<div class="switch-field">
							<?php
							$yesChecked = "";
							$noChecked = "checked";
							?>
							<input type="radio" id="is_default" name="is_default" value="yes" <?= $yesChecked; ?> />
							<label for="is_default"><?= TRANS('YES'); ?></label>
							<input type="radio" id="is_default_no" name="is_default" value="no" <?= $noChecked; ?> />
							<label for="is_default_no"><?= TRANS('NOT'); ?></label>
						</div>
					</div>


					<div class="row w-100"></div>
					<div class="form-group col-md-8 d-none d-md-block">
					</div>
					<div class="form-group col-12 col-md-2 ">

						<input type="hidden" name="action" id="action" value="new">
						<button type="submit" id="idSubmit" name="submit" class="btn btn-primary btn-block"><?= TRANS('BT_OK'); ?></button>
					</div>
					<div class="form-group col-12 col-md-2">
						<button type="reset" class="btn btn-secondary btn-block" onClick="parent.history.back();"><?= TRANS('BT_CANCEL'); ?></button>
					</div>


				</div>
			</form>
		<?php
		} else

		if ((isset($_GET['action']) && $_GET['action'] == "edit") && empty($_POST['submit'])) {

			$row = $resultado->fetch();
		?>
			<h6><?= TRANS('BT_EDIT'); ?></h6>
			<form method="post" action="<?= $_SERVER['PHP_SELF']; ?>" id="form">
				<?= csrf_input(); ?>
				<div class="form-group row my-4">
                    <label for="level_name" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('COL_NAME'); ?></label>
					<div class="form-group col-md-10">
						<input type="text" class="form-control " id="level_name" name="level_name" value="<?= $row['pr_desc'] ;?>" required />
					</div>

					<label for="level" class="col-md-2 col-form-label text-md-right"><?= TRANS('LEVEL'); ?></label>
					<div class="form-group col-md-10">
						<select class="form-control " id="level" name="level" >
							<option value=""><?= TRANS('SEL_SELECT'); ?></option>
							<?php
                            $sql = "SELECT * FROM prior_nivel WHERE prn_cod NOT IN ({$usedLevels}) ORDER BY prn_level";
							$commit = $conn->query($sql);
							foreach ($commit->fetchAll() as $rowPr) {
                                ?>
                                <option value="<?= $rowPr['prn_cod']; ?>"
                                    <?= ($row['pr_nivel'] == $rowPr['prn_cod'] ? ' selected' : ''); ?>
                                ><?= $rowPr["prn_level"]; ?></option>
                                <?php
							}
							?>
						</select>
						<small class="text-muted"><?= TRANS('HELPER_LEVEL_ORDER'); ?></small>
                    </div>
                    <label for="priority_color" class="col-md-2 col-form-label text-md-right"><?= TRANS('COL_BG_COLOR'); ?></label>
					<div class="form-group col-md-10">
						<input type="color" class="form-control " id="priority_color" name="priority_color" value="<?= $row['pr_color']; ?>" required />
                    </div>

                    <label for="priority_font_color" class="col-md-2 col-form-label text-md-right"><?= TRANS('FONT_COLOR'); ?></label>
					<div class="form-group col-md-10">
						<input type="color" class="form-control " id="priority_font_color" name="priority_font_color" value="<?= $row['pr_font_color']; ?>" required />
                    </div>

					<label for="sample" class="col-md-2 col-form-label text-md-right"><?= TRANS('APPEARANCE'); ?></label>
					<div class="form-group col-md-10">
						<span class="btn btn-sm cursor-no-event" style="color: <?= $row['pr_font_color']; ?>; background-color: <?= $row['pr_color']; ?>" id="appearance"><?= TRANS('SAMPLE'); ?></span>
                    </div>
                    
                    <label class="col-md-2 col-form-label text-md-right" data-toggle="popover" data-placement="top" data-trigger="hover" data-content="<?= TRANS('COL_DEFAULT'); ?>"><?= firstLetterUp(TRANS('COL_DEFAULT')); ?></label>
					<div class="form-group col-md-4 ">
						<div class="switch-field">
                            <?php
							$yesChecked = ($row['pr_default'] == 1 ? "checked" : "");
							$noChecked = (!($row['pr_default'] == 1) ? "checked" : "");
							?>
							<input type="radio" id="is_default" name="is_default" value="yes" <?= $yesChecked; ?> />
							<label for="is_default"><?= TRANS('YES'); ?></label>
							<input type="radio" id="is_default_no" name="is_default" value="no" <?= $noChecked; ?> />
							<label for="is_default_no"><?= TRANS('NOT'); ?></label>
						</div>
					</div>

					<input type="hidden" name="cod" value="<?= (int)$_GET['cod']; ?>">
					<input type="hidden" name="action" id="action" value="edit">

					<div class="row w-100"></div>
					<div class="form-group col-md-8 d-none d-md-block">
					</div>
					<div class="form-group col-12 col-md-2 ">
						<button type="submit" id="idSubmit" name="submit" value="edit" class="btn btn-primary btn-block"><?= TRANS('BT_OK'); ?></button>
					</div>
					<div class="form-group col-12 col-md-2">
						<button type="reset" class="btn btn-secondary btn-block" onClick="parent.history.back();"><?= TRANS('BT_CANCEL'); ?></button>
					</div>

				</div>
			</form>
		<?php
		}
		?>
	</div>

	<script src="../../includes/javascript/funcoes-3.0.js"></script>
	<script src="../../includes/components/jquery/jquery.js"></script>
	<!-- <script type="text/javascript" src="../../includes/components/jquery/jquery-ui-1.12.1/jquery-ui.js"></script> -->
	<script src="../../includes/components/bootstrap/js/bootstrap.min.js"></script>
	<script type="text/javascript" charset="utf8" src="../../includes/components/datatables/datatables.js"></script>
	<script type="text/javascript">
		$(function() {

			$('#table_lists').DataTable({
				paging: true,
				deferRender: true,
				columnDefs: [{
					searchable: false,
					orderable: false,
					targets: ['color', 'editar', 'remover']
				}],
				"language": {
					"url": "../../includes/components/datatables/datatables.pt-br.json"
				}
			});

			if ($("#level_name").val() != '') {
				$("#appearance").text($("#level_name").val());
			}

			$("#priority_color, #priority_font_color").on('change', function() {
				$("#appearance").css({
					"background-color": $("#priority_color").val(),
					"color": $("#priority_font_color").val()
				}).text($("#level_name").val());
			});


			$('input, select, textarea').on('change', function() {
				$(this).removeClass('is-invalid');
			});
			
			$('#idSubmit').on('click', function(e) {
				e.preventDefault();
				var loading = $(".loading");
				$(document).ajaxStart(function() {
					loading.show();
				});
				$(document).ajaxStop(function() {
					loading.hide();
				});

				$("#idSubmit").prop("disabled", true);
				$.ajax({
					url: './priorities_process.php',
					method: 'POST',
					data: $('#form').serialize(),
					dataType: 'json',
				}).done(function(response) {

					if (!response.success) {
						$('#divResult').html(response.message);
						$('input, select, textarea').removeClass('is-invalid');
						if (response.field_id != "") {
							$('#' + response.field_id).focus().addClass('is-invalid');
						}
						$("#idSubmit").prop("disabled", false);
					} else {
						$('#divResult').html('');
						$('input, select, textarea').removeClass('is-invalid');
						$("#idSubmit").prop("disabled", false);
						var url = '<?= $_SERVER['PHP_SELF'] ?>';
						$(location).prop('href', url);
						return false;
					}
				});
				return false;
			});

			$('#idBtIncluir').on("click", function() {
				$('#idLoad').css('display', 'block');
				var url = '<?= $_SERVER['PHP_SELF'] ?>?action=new';
				$(location).prop('href', url);
			});

			$('#bt-cancel').on('click', function() {
				var url = '<?= $_SERVER['PHP_SELF'] ?>';
				$(location).prop('href', url);
			});
		});


		function confirmDeleteModal(id) {
			$('#deleteModal').modal();
			$('#deleteButton').html('<a class="btn btn-danger" onclick="deleteData(' + id + ')"><?= TRANS('REMOVE'); ?></a>');
		}

		function deleteData(id) {

			var loading = $(".loading");
			$(document).ajaxStart(function() {
				loading.show();
			});
			$(document).ajaxStop(function() {
				loading.hide();
			});

			$.ajax({
				url: './priorities_process.php',
				method: 'POST',
				data: {
					cod: id,
					action: 'delete'
				},
				dataType: 'json',
			}).done(function(response) {
				var url = '<?= $_SERVER['PHP_SELF'] ?>';
				$(location).prop('href', url);
				return false;
			});
			return false;
			// $('#deleteModal').modal('hide'); // now close modal
		}
	</script>
</body>

</html>