<?php session_start();
/*      Copyright 2023 Flávio Ribeiro

        This file is part of OCOMON.

        OCOMON is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 3 of the License, or
        (at your option) any later version.
        OCOMON is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with Foobar; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

if (!isset($_SESSION['s_logado']) || $_SESSION['s_logado'] == 0) {
    $_SESSION['session_expired'] = 1;
    echo "<script>top.window.location = '../../index.php'</script>";
    exit;
}

require_once __DIR__ . "/" . "../../includes/include_basics_only.php";
require_once __DIR__ . "/" . "../../includes/classes/ConnectPDO.php";

use includes\classes\ConnectPDO;

$conn = ConnectPDO::getInstance();

$post = $_POST;

$erro = false;
$screenNotification = "";
$exception = "";
$data = [];
$data['success'] = true;
$data['message'] = "";
$data['cod'] = (isset($post['cod']) ? intval($post['cod']) : "");
$data['action'] = $post['action'];
$data['field_id'] = "";

$data['sigla'] = (isset($post['sigla']) ? noHtml($post['sigla']) : "");
$data['description'] = (isset($post['description']) ? noHtml($post['description']) : "");
$data['context'] = (isset($post['context']) && !empty($post['context']) ? (int)$post['context'] : null);
$data['subject'] = (isset($post['subject']) ? noHtml($post['subject']) : "");
$data['body_content'] = (isset($post['body_content']) ? $post['body_content'] : "");



/* Validações */
if ($data['action'] == "new" || $data['action'] == "edit") {

    if (empty($data['sigla']) || empty($data['subject']) || empty($data['body_content'])) {
        $data['success'] = false; 
        $data['field_id'] = (empty($data['sigla']) ? 'sigla' : (empty($data['subject']) ? 'subject' : 'body_content'));
        $data['message'] = message('warning', 'Ooops!', TRANS('MSG_EMPTY_DATA'),'');
        echo json_encode($data);
        return false;
    }

    // if (!valida('E-mail', $data['subject'], 'MAILMULTI', 1, $screenNotification)) {
    //     $data['success'] = false; 
    //     $data['field_id'] = "subject";
    //     $data['message'] = message('warning', 'Ooops!', $screenNotification,'');
    //     echo json_encode($data);
    //     return false;
    // }
}


if ($data['action'] == 'new') {


    if (!csrf_verify($post)) {
        $data['success'] = false; 
        $data['message'] = message('warning', 'Ooops!', TRANS('FORM_ALREADY_SENT'),'');
    
        echo json_encode($data);
        return false;
    }

    // $tems = (!empty($data['context']) ? $data['context'] : '');

    $sql = "INSERT INTO mail_templates 
            (
                tpl_sigla,
                description,
                context,
                tpl_subject, 
                tpl_msg_html
            ) 
            values 
            (
                :sigla, 
                :description,
                :context,
                :subject, 
                :body_content
            )";

    try {
        $res = $conn->prepare($sql);
        $res->bindParam(':sigla', $data['sigla'], PDO::PARAM_STR);
        $res->bindParam(':description', $data['description'], PDO::PARAM_STR);
        $res->bindParam(':context', $data['context'], PDO::PARAM_INT);
        $res->bindParam(':subject', $data['subject'], PDO::PARAM_STR);
        $res->bindParam(':body_content', $data['body_content'], PDO::PARAM_STR);

        $res->execute();
        
        $data['success'] = true; 
        $data['message'] = TRANS('MSG_SUCCESS_INSERT');
        $_SESSION['flash'] = message('success', '', $data['message'], '');
        echo json_encode($data);
        return false;
    } catch (Exception $e) {
        $data['success'] = false; 
        $data['message'] = TRANS('MSG_ERR_SAVE_RECORD');
        $_SESSION['flash'] = message('danger', '', $data['message'], '');
        echo json_encode($data);
        return false;
    }

} elseif ($data['action'] == 'edit') {

    if (!csrf_verify($post)) {
        $data['success'] = false; 
        $data['message'] = message('warning', 'Ooops!', TRANS('FORM_ALREADY_SENT'),'');
    
        echo json_encode($data);
        return false;
    }

    

    $sql = "UPDATE mail_templates SET 
                tpl_sigla = :sigla,
                description = :description,
                context = :context, 
                tpl_subject = :subject,
                tpl_msg_html = :body_content, 
                tpl_msg_text = null
            WHERE tpl_cod = :cod ";

    try {
        
        $res = $conn->prepare($sql);
        $res->bindParam(':sigla', $data['sigla'], PDO::PARAM_STR);
        $res->bindParam(':description', $data['description'], PDO::PARAM_STR);
        $res->bindParam(':context', $data['context'], PDO::PARAM_INT);
        $res->bindParam(':subject', $data['subject'], PDO::PARAM_STR);
        $res->bindParam(':body_content', $data['body_content'], PDO::PARAM_STR);
        $res->bindParam(':cod', $data['cod'], PDO::PARAM_INT);

        $res->execute();
        
        $data['success'] = true; 
        $data['message'] = TRANS('MSG_SUCCESS_EDIT');
        $_SESSION['flash'] = message('success', '', $data['message'], '');
        echo json_encode($data);
        return false;
    } catch (Exception $e) {
        $exception .= "<hr>" . $e->getMessage();
        $data['success'] = false; 
        // $data['message'] = TRANS('MSG_ERR_DATA_UPDATE');
        // $_SESSION['flash'] = message('danger', '', $data['message'] . $exception, '');
        $data["message"] = message('danger', '', TRANS('MSG_ERR_DATA_UPDATE') . $exception, '');
        echo json_encode($data);
        return false;
    }

} elseif ($data['action'] == 'delete') {
    $sql = "DELETE FROM mail_templates WHERE tpl_cod = '" . $data['cod'] . "'";

    try {
        $conn->exec($sql);
        $data['success'] = true; 
        $data['message'] = TRANS('OK_DEL');
        $_SESSION['flash'] = message('success', '', $data['message'], '');
        echo json_encode($data);
        return false;
    } catch (Exception $e) {
        $data['success'] = false; 
        $data['message'] = TRANS('MSG_ERR_DATA_REMOVE');
        $_SESSION['flash'] = message('danger', '', $data['message'], '');
        echo json_encode($data);
        return false;
    }
    
}

echo json_encode($data);