<?php session_start();
/*      Copyright 2023 Flávio Ribeiro

        This file is part of OCOMON.

        OCOMON is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 3 of the License, or
        (at your option) any later version.
        OCOMON is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with Foobar; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

if (!isset($_SESSION['s_logado']) || $_SESSION['s_logado'] == 0) {
    $_SESSION['session_expired'] = 1;
    echo "<script>top.window.location = '../../index.php'</script>";
    exit;
}



require_once __DIR__ . "/" . "../../includes/include_basics_only.php";
require_once __DIR__ . "/" . "../../includes/classes/ConnectPDO.php";

use includes\classes\ConnectPDO;
$conn = ConnectPDO::getInstance();

/* Configurações globais */
// $config = getConfig($conn);

$author_department = getUserDepartment($conn, $_SESSION['s_uid']);

if ($_SESSION['s_nivel'] > 2 && empty($author_department)) {
    exit;
}


$post = $_POST;

$erro = false;
$screenNotification = "";
$exception = "";
$data = [];
$data['success'] = true;
$data['message'] = "";
$data['cod'] = (isset($post['cod']) ? intval($post['cod']) : "");
$data['field_id'] = "";

$data['requester'] = (isset($post['requester']) ? (int)$post['requester'] : "");
$data['params'] = (isset($post['params']) ? noHtml($post['params']) : "");

$paramPrefix = "amp;";
if (isset($data['params']) && !empty($data['params'])) {
	$data['params'] = str_replace($paramPrefix, "", $data['params']);
}

if (empty($data['requester'])) {
    $data['success'] = false; 
    $data['field_id'] = "requester";
    $data['message'] = message('warning', 'Ooops!', TRANS('MSG_EMPTY_DATA'),'');
    echo json_encode($data);
    return false;
}

$requester_department = getUserDepartment($conn, $data['requester']);

if ($_SESSION['s_nivel'] > 2 && ($author_department != $requester_department || empty($requester_department))) {
    $data['success'] = false; 
    $data['field_id'] = "requester";
    $data['message'] = message('warning', 'Ooops!', TRANS('MSG_INVALID_REQUESTER'),'');
    echo json_encode($data);
    return false;
}

echo json_encode($data);
