<?php 
session_start();

require_once (__DIR__ . "/../include_basics_only.php");
require_once __DIR__ . "/" . "../classes/ConnectPDO.php";
use includes\classes\ConnectPDO;

$globalAccess = false;
$ticket = (isset($_GET['file']) ? (int)$_GET['file'] : '');
$fileId = (isset($_GET['cod']) ? (int)$_GET['cod'] : ''); 

if (empty($ticket) || empty($fileId)) {
    exit;
}

$id = (isset($_GET['id'])) ? $_GET['id'] : '';

$conn = ConnectPDO::getInstance();

if (!empty($id)) {
    $id = str_replace(" ", "+", (string)$id);
    $id = noHtml($id);

    if (asEquals($id, getGlobalTicketId($conn, $ticket))) {
        $globalAccess = true;
    }
}

if (((!isset($_SESSION['s_logado']) || $_SESSION['s_logado'] != 1) && !$globalAccess)) {
    exit;
}


$isAdmin = (isset($_SESSION['s_nivel']) && $_SESSION['s_nivel'] == 1) ? true : false;

if (!$globalAccess && !$isAdmin) {
	/* Controle de acesso */

    $ticketData = getTicketData($conn, $ticket, ['sistema', 'aberto_por', 'registration_operator']);

	$isRequester = $ticketData['aberto_por'] == $_SESSION['s_uid'];

	if (!$isRequester) {
    
		$isBasicUser = ($_SESSION['s_nivel'] == 3) ? true : false;
		$isRegistrationUser = $_SESSION['s_uid'] == $ticketData['registration_operator'];
		
		if ($isBasicUser && !$isRegistrationUser) {
			/* Pode ser gerente de área */
			$managebleAreas = getManagedAreasByUser($conn, $_SESSION['s_uid']);
			$managebleAreas = array_column($managebleAreas, 'sis_id');
			
			$openerArea = getOpenerInfo($conn, $ticketData['aberto_por'])['AREA'];
			$isAreaAdmin = in_array($openerArea, $managebleAreas);
			
			if (!$_SESSION['s_area_admin'] || !in_array($openerArea, $managebleAreas)) {
				echo message('danger', 'Ooops!', TRANS('MSG_NOT_ALLOWED'), '', '', true);
				exit;
			}
		} elseif ($_SESSION['s_nivel'] == 2 && !$isRegistrationUser) {
			/* Usuário com nível de operação */
			$uareas = explode(',', (string)$_SESSION['s_uareas']);
			if (!in_array($ticketData['sistema'], $uareas)) {
				echo message('danger', 'Ooops!', TRANS('MSG_NOT_ALLOWED'), '', '', true);
				exit;
			}
		}
		/* Se for o $isRegistrationUser, pode acessar o conteúdo */
	}
	/* Se for o solicitante, pode acessar o conteúdo */
}


$query = "SELECT * FROM 
			imagens 
		WHERE 
			img_cod = :file_id AND
			img_oco = :ticket 
		LIMIT 1";

try {
	$result = $conn->prepare($query);
	$result->bindValue(':file_id', $fileId, PDO::PARAM_INT);
	$result->bindValue(':ticket', $ticket, PDO::PARAM_INT);
	$result->execute();

	$data = $result->fetch();

	if (!empty($data["img_bin"])) {
		if (ob_get_length()) {
			ob_end_clean();
		}
		
		// Saída MIME header
		header("Content-Type: {$data["img_tipo"]}");
		// Saída da imagen
		echo $data["img_bin"];
	}
}
catch (Exception $e) {
	message('danger', 'Ooops!', TRANS('MSG_ERR_GET_DATA'), '', '', 1);
	return;
}
?>