<?php session_start();
/*      Copyright 2023 Flávio Ribeiro

        This file is part of OCOMON.

        OCOMON is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 3 of the License, or
        (at your option) any later version.
        OCOMON is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with Foobar; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

if (!isset($_SESSION['s_logado']) || $_SESSION['s_logado'] == 0) {
    $_SESSION['session_expired'] = 1;
    echo "<script>top.window.location = '../../index.php'</script>";
    exit;
}

require_once __DIR__ . "/" . "../../includes/include_basics_only.php";
require_once __DIR__ . "/" . "../../includes/classes/ConnectPDO.php";

use includes\classes\ConnectPDO;

$conn = ConnectPDO::getInstance();

$post = $_POST;



$screenNotification = "";
$exception = "";
$data = [];
$data['success'] = true;
$data['message'] = "";
$data['cod'] = (isset($post['cod']) ? intval($post['cod']) : "");
$data['action'] = $post['action'];
$data['field_id'] = "";

$data['department'] = (isset($post['department']) ? noHtml($post['department']) : "");
$data['unit'] = (isset($post['unit']) ? noHtml($post['unit']) : "");
$data['department_status'] = (isset($post['department_status']) ? ($post['department_status'] == "yes" ? 1 : 0) : 0);
$data['building'] = (isset($post['building']) && $post['building'] != '-1' ? noHtml($post['building']) : "");
$data['rectory'] = (isset($post['rectory']) && $post['rectory'] != '-1' ? noHtml($post['rectory']) : "");
$data['net_domain'] = (isset($post['net_domain']) && $post['net_domain'] != '-1' ? noHtml($post['net_domain']) : "");
$data['response_level'] = (isset($post['response_level']) && $post['response_level'] != '-1' ? noHtml($post['response_level']) : "");




/* Validações */
if ($data['action'] == "new" || $data['action'] == "edit") {

    if (empty($data['department'])) {
        $data['success'] = false; 
        $data['field_id'] = 'department';
    }


    if ($data['success'] == false) {
        $data['message'] = message('warning', 'Ooops!', TRANS('MSG_EMPTY_DATA'),'');
        echo json_encode($data);
        return false;
    }

}




if ($data['action'] == 'new') {

    $terms = (!empty($data['unit']) ? " AND loc_unit = '{$data['unit']}' " : " AND loc_unit IS NULL ");
    


    $sql = "SELECT loc_id FROM localizacao WHERE local = '" . $data['department'] . "' {$terms} ";
    $res = $conn->query($sql);
    if ($res->rowCount()) {
        $data['success'] = false; 
        $data['field_id'] = "area";
        $data['message'] = message('warning', '', TRANS('MSG_RECORD_EXISTS'), '');
        echo json_encode($data);
        return false;
    }


    if (!csrf_verify($post)) {
        $data['success'] = false; 
        $data['message'] = message('warning', 'Ooops!', TRANS('FORM_ALREADY_SENT'),'');
    
        echo json_encode($data);
        return false;
    }

    $sql = "INSERT INTO 
                localizacao 
                (
                    local, 
                    loc_reitoria, 
                    loc_prior, 
                    loc_dominio, 
                    loc_predio, 
                    loc_unit
                ) 
                VALUES 
                (
                    '" . $data['department'] . "', 
                    " . dbField($data['rectory']) . ", 
                    " . dbField($data['response_level']) . ", 
                    " . dbField($data['net_domain']) . ", 
                    " . dbField($data['building']) . ", 
                    " . dbField($data['unit']) . " 
                )
    ";

    try {
        $conn->exec($sql);
        $data['success'] = true; 
        $data['message'] = TRANS('MSG_SUCCESS_INSERT');

        $_SESSION['flash'] = message('success', '', $data['message'] . $exception, '');
        echo json_encode($data);
        return false;
    } catch (Exception $e) {
        $exception .= "<hr>" . $e->getMessage() . "<hr>" . $sql;
        $data['success'] = false; 
        $data['message'] = TRANS('MSG_ERR_SAVE_RECORD');
        $_SESSION['flash'] = message('danger', '', $data['message'] . $exception, '');
        echo json_encode($data);
        return false;
    }

} elseif ($data['action'] == 'edit') {


    $terms = (!empty($data['unit']) ? " AND loc_unit = '{$data['unit']}' " : " AND loc_unit IS NULL ");

    $sql = "SELECT loc_id FROM localizacao WHERE local = '" . $data['department'] . "' {$terms} AND loc_id <> '" . $data['cod'] . "' ";
    $res = $conn->query($sql);
    if ($res->rowCount()) {
        $data['success'] = false; 
        $data['field_id'] = "area";
        $data['message'] = message('warning', '', TRANS('MSG_RECORD_EXISTS'), '');
        echo json_encode($data);
        return false;
    }

    if (!csrf_verify($post)) {
        $data['success'] = false; 
        $data['message'] = message('warning', 'Ooops!', TRANS('FORM_ALREADY_SENT'),'');
    
        echo json_encode($data);
        return false;
    }


    $sql = "UPDATE localizacao SET 
                local = '" . $data['department'] . "', 
                loc_reitoria = " . dbField($data['rectory']) . ", 
                loc_prior = " . dbField($data['response_level']) . ", 
                loc_dominio = " . dbField($data['net_domain']) . ", 
                loc_predio = " . dbField($data['building']) . ", 
                loc_status = '" . $data['department_status'] . "', 
                loc_unit = " . dbField($data['unit']) . " 

            WHERE loc_id = '" . $data['cod'] . "'";

    try {
        $conn->exec($sql);
        $data['success'] = true; 
        $data['message'] = TRANS('MSG_SUCCESS_EDIT');

        $_SESSION['flash'] = message('success', '', $data['message'] . $exception, '');
        echo json_encode($data);
        return false;
    } catch (Exception $e) {
        $exception .= "<hr>" . $e->getMessage() . "<hr>" . $sql;
        $data['success'] = false; 
        $data['message'] = TRANS('MSG_ERR_DATA_UPDATE');
        $_SESSION['flash'] = message('danger', '', $data['message'] . $exception, '');
        echo json_encode($data);
        return false;
    }

} elseif ($data['action'] == 'delete') {


    
    /* Confere na tabela de ocorrências se a área está associada */
    $sql = "SELECT numero FROM ocorrencias WHERE local = '" . $data['cod'] . "' ";
    $res = $conn->query($sql);
    if ($res->rowCount()) {
        $data['success'] = false; 
        $data['message'] = TRANS('MSG_CANT_DEL');
        $_SESSION['flash'] = message('danger', '', $data['message'] . $exception, '');
        echo json_encode($data);
        return false;
    }


    /* Sem restrições para excluir o departamento */
    $sql = "DELETE FROM localizacao WHERE loc_id = '" . $data['cod'] . "'";

    try {
        $conn->exec($sql);
        $data['success'] = true; 
        $data['message'] = TRANS('OK_DEL');

        $_SESSION['flash'] = message('success', '', $data['message'] . $exception, '');
        echo json_encode($data);
        return false;
    } catch (Exception $e) {
        $exception .= "<hr>" . $e->getMessage() . "<hr>" . $sql;
        $data['success'] = false; 
        $data['message'] = TRANS('MSG_ERR_DATA_REMOVE');
        $_SESSION['flash'] = message('danger', '', $data['message'] . $exception, '');
        echo json_encode($data);
        return false;
    }
    
}

echo json_encode($data);