<?php
/* Copyright 2023 Flávio Ribeiro

This file is part of OCOMON.

OCOMON is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

OCOMON is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Foobar; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */ session_start();

if (!isset($_SESSION['s_logado']) || $_SESSION['s_logado'] == 0) {
	$_SESSION['session_expired'] = 1;
    echo "<script>top.window.location = '../../index.php'</script>";
	exit;
}

require_once __DIR__ . "/" . "../../includes/include_geral_new.inc.php";
require_once __DIR__ . "/" . "../../includes/classes/ConnectPDO.php";

use includes\classes\ConnectPDO;

$conn = ConnectPDO::getInstance();

$auth = new AuthNew($_SESSION['s_logado'], $_SESSION['s_nivel'], 1);

$_SESSION['s_page_admin'] = $_SERVER['PHP_SELF'];

?>
<!DOCTYPE html>
<html lang="pt-BR">

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" type="text/css" href="../../includes/css/estilos.css" />
    <link rel="stylesheet" type="text/css" href="../../includes/css/switch_radio.css" />
	<link rel="stylesheet" type="text/css" href="../../includes/components/bootstrap/custom.css" />
	<link rel="stylesheet" type="text/css" href="../../includes/components/fontawesome/css/all.min.css" />
	<link rel="stylesheet" type="text/css" href="../../includes/components/datatables/datatables.min.css" />
	<link rel="stylesheet" type="text/css" href="../../includes/css/my_datatables.css" />
	<link rel="stylesheet" type="text/css" href="../../includes/components/bootstrap-select/dist/css/bootstrap-select.min.css" />
    <link rel="stylesheet" type="text/css" href="../../includes/css/my_bootstrap_select.css" />
	<link rel="stylesheet" type="text/css" href="../../includes/css/estilos_custom.css" />

	<title><?= APP_NAME; ?>&nbsp;<?= VERSAO; ?></title>
</head>

<body>
    
	<div class="container">
		<div id="idLoad" class="loading" style="display:none"></div>
	</div>

	<div id="divResult"></div>

	<input type="hidden" name="label_close" id="label_close" value="<?= TRANS('BT_CLOSE'); ?>">
	<input type="hidden" name="label_return" id="label_return" value="<?= TRANS('TXT_RETURN'); ?>">


	<div class="container-fluid">
		<h4 class="my-4"><i class="fas fa-sort-numeric-up-alt text-secondary"></i>&nbsp;<?= TRANS('TECH_LEVELS'); ?></h4>
		<div class="modal" id="modal" tabindex="-1" style="z-index:9001!important">
			<div class="modal-dialog modal-xl">
				<div class="modal-content">
					<div id="divDetails">
					</div>
				</div>
			</div>
		</div>

		<?php
		if (isset($_SESSION['flash']) && !empty($_SESSION['flash'])) {
			echo $_SESSION['flash'];
			$_SESSION['flash'] = '';
        }
		
		
		$techLevels = (isset($_GET['cod']) ? getTechLevels($conn, (int)$_GET['cod']) : getTechLevels($conn));
		$registros = count($techLevels);

		if ((!isset($_GET['action'])) && !isset($_POST['submit'])) {

		?>
			<!-- Modal -->
			<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content">
						<div class="modal-header bg-light">
							<h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-exclamation-triangle text-secondary"></i>&nbsp;<?= TRANS('REMOVE'); ?></h5>
							<button type="button" class="close" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body">
							<?= TRANS('CONFIRM_REMOVE'); ?> <span class="j_param_id"></span>?
						</div>
						<div class="modal-footer bg-light">
							<button type="button" class="btn btn-secondary" data-dismiss="modal"><?= TRANS('BT_CANCEL'); ?></button>
							<button type="button" id="deleteButton" class="btn"><?= TRANS('BT_OK'); ?></button>
						</div>
					</div>
				</div>
			</div>

			<button class="btn btn-sm btn-primary" id="idBtIncluir" name="new"><?= TRANS("ACT_NEW"); ?></button><br /><br />
			
			<?php
			if ($registros == 0) {
				echo message('info', '', TRANS('NO_RECORDS_FOUND'), '', '', true);
			} else {

			?>
				<table id="table_lists" class="stripe hover order-column row-border" border="0" cellspacing="0" width="100%">

					<thead>
						<tr class="header">
                            <td class="line client"><?= TRANS('LEVEL'); ?></td>
                            <td class="line client"><?= TRANS('DESCRIPTION'); ?></td>
                            <td class="line issue_type"><?= TRANS('BASE_SALARY'); ?></td>
                            <td class="line issue_type"><?= TRANS('HOUR_PRICE'); ?></td>
                            <td class="line issue_type"><?= TRANS('UNIT_PRICE'); ?></td>
                            <td class="line issue_type"><?= TRANS('PRICE_SINCE'); ?></td>
							<td class="line editar" width="10%"><?= TRANS('BT_EDIT'); ?></td>
							<td class="line remover" width="10%"><?= TRANS('BT_REMOVE'); ?></td>
						</tr>
					</thead>
					<tbody>
						<?php
						foreach ($techLevels as $row) {
							?>
							<tr>
                                <td class="line"><?= $row['name']; ?></td>
                                <td class="line"><?= $row['description']; ?></td>
                                <td class="line"><?= priceScreen($row['base_price']); ?></td>
                                <td class="line"><?= priceScreen($row['hour_price']); ?></td>
                                <td class="line"><?= priceScreen($row['unit_price']); ?></td>
                                <td class="line"><?= dateScreen($row['vigence_since']); ?></td>
								<td class="line"><button type="button" class="btn btn-secondary btn-sm" onclick="redirect('<?= $_SERVER['PHP_SELF']; ?>?action=edit&cod=<?= $row['id']; ?>')"><?= TRANS('BT_EDIT'); ?></button></td>
								<td class="line"><button type="button" class="btn btn-danger btn-sm" onclick="confirmDeleteModal('<?= $row['id']; ?>')"><?= TRANS('REMOVE'); ?></button></td>
							</tr>
						<?php
						}
						?>
					</tbody>
				</table>
			<?php
			}
		} else
		if ((isset($_GET['action'])  && ($_GET['action'] == "new")) && !isset($_POST['submit'])) {

			?>
			<h6><?= TRANS('NEW_RECORD'); ?></h6>
			<form method="post" action="<?= $_SERVER['PHP_SELF']; ?>" id="form">
				<?= csrf_input('tech_levels'); ?>
				<div class="form-group row my-4">
					
					<label for="tech_level_name" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('LEVEL'); ?></label>
					<div class="form-group col-md-10">
						<input type="text" class="form-control " id="tech_level_name" name="tech_level_name" required />
                    </div>
					
					<label for="tech_level_description" class="col-md-2 col-form-label col-form-label-sm text-md-right" data-toggle="popover" data-placement="top" data-trigger="hover" data-content="<?= TRANS('DESCRIPTION'); ?>"><?= firstLetterUp(TRANS('DESCRIPTION')); ?></label>
					<div class="form-group col-md-10 ">
						<textarea class="form-control" name="tech_level_description" id="tech_level_description"></textarea>
					</div>

					<div class="form-group col-md-2">
					</div>
					<div class="form-group col-md-10">
						<hr />
                    </div>

					<label for="tech_base_price" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('BASE_SALARY'); ?></label>
					<div class="form-group col-md-4">
						<div class="input-group">
							<div class="input-group-prepend">
								<div class="input-group-text " title="<?= TRANS('HELPER_BASE_SALARY'); ?>" data-placeholder="<?= TRANS('HELPER_BASE_SALARY'); ?>" data-toggle="popover" data-placement="top" data-trigger="hover">
									<?= TRANS('CURRENCY'); ?>&nbsp;
								</div>
                        	</div>
							<input type="text" class="form-control " id="tech_base_price" name="tech_base_price"  />
						</div>
                    </div>
					<label for="hour_price_divisor" class="col-md-2 col-form-label col-form-label-sm text-md-right "><?= TRANS('HOUR_PRICE_DIVISOR'); ?></label>
					<div class="form-group col-md-4">
						<input type="number" class="form-control " id="hour_price_divisor" name="hour_price_divisor" value="220" min="1" />
                    </div>
					
					<label for="hour_price" class="col-md-2 col-form-label col-form-label-sm text-md-right "><?= TRANS('HOUR_PRICE'); ?></label>
					<div class="form-group col-md-4">
						
						<div class="input-group">
							<div class="input-group-prepend">
								<div class="input-group-text " title="<?= TRANS('HELPER_HOUR_PRICE'); ?>" data-placeholder="<?= TRANS('HELPER_HOUR_PRICE'); ?>" data-toggle="popover" data-placement="top" data-trigger="hover">
									<?= TRANS('CURRENCY'); ?>&nbsp;
								</div>
                        	</div>
							<input type="text" class="form-control " id="hour_price" name="hour_price" disabled />
						</div>
					
                    </div>
					

					<label for="unit_price_divisor" class="col-md-2 col-form-label col-form-label-sm text-md-right "><?= TRANS('UNIT_PRICE_DIVISOR'); ?></label>
					<div class="form-group col-md-4">
						<input type="number" class="form-control " id="unit_price_divisor" name="unit_price_divisor" value="5" min="1" />
                    </div>
					
					<label for="unit_price" class="col-md-2 col-form-label col-form-label-sm text-md-right "><?= TRANS('UNIT_PRICE'); ?></label>
					<div class="form-group col-md-4">
						
						<div class="input-group">
							<div class="input-group-prepend">
								<div class="input-group-text " title="<?= TRANS('HELPER_UNIT_PRICE'); ?>" data-placeholder="<?= TRANS('HELPER_UNIT_PRICE'); ?>" data-toggle="popover" data-placement="top" data-trigger="hover">
									<?= TRANS('CURRENCY'); ?>&nbsp;
								</div>
                        	</div>
							<input type="text" class="form-control " id="unit_price" name="unit_price" disabled />
						</div>
					
                    </div>




					
					<div class="form-group col-md-2">
					</div>
					<div class="form-group col-md-10">
						<hr />
                    </div>


					<div class="row w-100"></div>
					<div class="form-group col-md-8 d-none d-md-block">
					</div>
					<div class="form-group col-12 col-md-2 ">

						<input type="hidden" name="action" id="action" value="new">
						<button type="submit" id="idSubmit" name="submit" class="btn btn-primary btn-block"><?= TRANS('BT_OK'); ?></button>
					</div>
					<div class="form-group col-12 col-md-2">
						<button type="reset" id="close_details" class="btn btn-secondary btn-block"><?= TRANS('BT_CANCEL'); ?></button>
					</div>


				</div>
			</form>
		<?php
		} else

		if ((isset($_GET['action']) && $_GET['action'] == "edit") && empty($_POST['submit'])) {

			$row = $techLevels;
		    ?>
			<h6><?= TRANS('BT_EDIT'); ?></h6>
			<form method="post" action="<?= $_SERVER['PHP_SELF']; ?>" id="form">
				<?= csrf_input('tech_levels'); ?>
				<div class="form-group row my-4">


					<label for="tech_level_name" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('LEVEL'); ?></label>
					<div class="form-group col-md-10">
						<input type="text" class="form-control " id="tech_level_name" name="tech_level_name" value="<?= $row['name']; ?>" required />
                    </div>

					<label for="tech_level_description" class="col-md-2 col-form-label col-form-label-sm text-md-right" data-toggle="popover" data-placement="top" data-trigger="hover" data-content="<?= TRANS('DESCRIPTION'); ?>"><?= firstLetterUp(TRANS('DESCRIPTION')); ?></label>
					<div class="form-group col-md-10 ">
						<textarea class="form-control" name="tech_level_description" id="tech_level_description"><?= $row['description']; ?></textarea>
					</div>

                    
					<label for="tech_base_price" class="col-md-2 col-form-label col-form-label-sm text-md-right"><?= TRANS('BASE_SALARY'); ?></label>
					<div class="form-group col-md-4">
						<div class="input-group">
							<div class="input-group-prepend">
								<div class="input-group-text " title="<?= TRANS('HELPER_BASE_SALARY'); ?>" data-placeholder="<?= TRANS('HELPER_BASE_SALARY'); ?>" data-toggle="popover" data-placement="top" data-trigger="hover">
									<?= TRANS('CURRENCY'); ?>&nbsp;
								</div>
                        	</div>
							<input type="text" class="form-control " id="tech_base_price" name="tech_base_price" value="<?= priceScreen($row['base_price']); ?>" />
						</div>
                    </div>
					<label for="hour_price_divisor" class="col-md-2 col-form-label col-form-label-sm text-md-right "><?= TRANS('HOUR_PRICE_DIVISOR'); ?></label>
					<div class="form-group col-md-4">
						<input type="number" class="form-control " id="hour_price_divisor" name="hour_price_divisor" value="<?= $row['hour_price_divisor']; ?>" min="1" />
                    </div>
					
					<label for="hour_price" class="col-md-2 col-form-label col-form-label-sm text-md-right "><?= TRANS('HOUR_PRICE'); ?></label>
					<div class="form-group col-md-4">
						
						<div class="input-group">
							<div class="input-group-prepend">
								<div class="input-group-text " title="<?= TRANS('HELPER_HOUR_PRICE'); ?>" data-placeholder="<?= TRANS('HELPER_HOUR_PRICE'); ?>" data-toggle="popover" data-placement="top" data-trigger="hover">
									<?= TRANS('CURRENCY'); ?>&nbsp;
								</div>
                        	</div>
							<input type="text" class="form-control " id="hour_price" name="hour_price" value="<?= priceScreen($row['hour_price']); ?>" disabled />
						</div>
					
                    </div>


					<label for="unit_price_divisor" class="col-md-2 col-form-label col-form-label-sm text-md-right "><?= TRANS('UNIT_PRICE_DIVISOR'); ?></label>
					<div class="form-group col-md-4">
						<input type="number" class="form-control " id="unit_price_divisor" name="unit_price_divisor" value="<?= $row['unit_price_divisor']; ?>" min="1" />
                    </div>
					
					<label for="unit_price" class="col-md-2 col-form-label col-form-label-sm text-md-right "><?= TRANS('UNIT_PRICE'); ?></label>
					<div class="form-group col-md-4">
						
						<div class="input-group">
							<div class="input-group-prepend">
								<div class="input-group-text " title="<?= TRANS('HELPER_UNIT_PRICE'); ?>" data-placeholder="<?= TRANS('HELPER_UNIT_PRICE'); ?>" data-toggle="popover" data-placement="top" data-trigger="hover">
									<?= TRANS('CURRENCY'); ?>&nbsp;
								</div>
                        	</div>
							<input type="text" class="form-control " id="unit_price" name="unit_price" value="<?= priceScreen($row['unit_price']); ?>" disabled />
						</div>
					
                    </div>


					<label for="price_since" class="col-md-2 col-form-label col-form-label-sm text-md-right "><?= TRANS('PRICE_SINCE'); ?></label>
					<div class="form-group col-md-4">
						<input type="text" class="form-control " id="price_since" name="price_since" value="<?= dateScreen($row['vigence_since']); ?>" disabled />
                    </div>

					<div class="form-group col-md-2">
					</div>
					<div class="form-group col-md-10">
						<hr />
                    </div>

					<div class="row w-100"></div>
					<div class="form-group col-md-8 d-none d-md-block">
					</div>
					<div class="form-group col-12 col-md-2 ">
                        <input type="hidden" name="cod" value="<?= (int)$_GET['cod']; ?>">
                        <input type="hidden" name="action" id="action" value="edit">
						<button type="submit" id="idSubmit" name="submit" value="edit" class="btn btn-primary btn-block"><?= TRANS('BT_OK'); ?></button>
					</div>
					<div class="form-group col-12 col-md-2">
						<button type="reset" id="close_details" class="btn btn-secondary btn-block"><?= TRANS('BT_CANCEL'); ?></button>
					</div>

				</div>
			</form>
		<?php
		}
		?>
	</div>

	<script src="../../includes/javascript/funcoes-3.0.js"></script>
	<script src="../../includes/components/jquery/jquery.js"></script>
    <script src="../../includes/components/jquery/plentz-jquery-maskmoney/dist/jquery.maskMoney.min.js"></script>
	<script src="../../includes/components/bootstrap/js/bootstrap.bundle.min.js"></script>
	<script type="text/javascript" charset="utf8" src="../../includes/components/datatables/datatables.js"></script>

	<script type="text/javascript">
		$(function() {

			$('#table_lists').DataTable({
				paging: true,
				deferRender: true,
				columnDefs: [{
					searchable: false,
					orderable: false,
					targets: ['editar', 'remover']
				}],
				"language": {
					"url": "../../includes/components/datatables/datatables.pt-br.json"
				}
			});

			/* Identificar se a janela está sendo carregada em uma popup (iframe dentro de uma modal) */
			if (isInIframe()) {
				if (!isMainIframe()) {
					$('#close_details').text($('#label_close').val()).on("click", function() {
						window.parent.closeIframe();
					});
				} else {
					$('#close_details').text($('#label_return').val()).on("click", function() {
						window.history.back();
					});
				}
			} else {
				$('#close_details').text($('#label_return').val()).on("click", function() {
					window.history.back();
				});
			}

			/* Trazer os parâmetros do banco a partir da opção que será criada para internacionaliação */
			$('#tech_base_price').maskMoney({
                prefix:'R$ ',
                thousands:'.', 
                decimal:',', 
                allowZero: false, 
                affixesStay: false
            });


			$('#tech_base_price, #hour_price_divisor, #unit_price_divisor').on('change', function() {

				let tech_base_price = $('#tech_base_price').val();
				let hour_price_divisor = $('#hour_price_divisor').val();
				let unit_price_divisor = $('#unit_price_divisor').val();

				tech_base_price = parseFloat(tech_base_price.replace(/\./g, '').replace(',', '.'));

				let hour_price = (tech_base_price / hour_price_divisor);
				let unit_price = (hour_price / unit_price_divisor);
				
				hour_price = hour_price.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
				unit_price = unit_price.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
				
				$('#hour_price').val(hour_price);
				$('#unit_price').val(unit_price);
			});


            $('input, select, textarea').on('change', function() {
				$(this).removeClass('is-invalid');
			});
			$('#idSubmit').on('click', function(e) {
				e.preventDefault();
				var loading = $(".loading");
				$(document).ajaxStart(function() {
					loading.show();
				});
				$(document).ajaxStop(function() {
					loading.hide();
				});

				$("#idSubmit").prop("disabled", true);
				$.ajax({
					url: './tech_levels_process.php',
					method: 'POST',
					data: $('#form').serialize(),
					dataType: 'json',
				}).done(function(response) {

					if (!response.success) {
						$('#divResult').html(response.message);
						$('input, select, textarea').removeClass('is-invalid');
						if (response.field_id != "") {
							$('#' + response.field_id).focus().addClass('is-invalid');
						}
						$("#idSubmit").prop("disabled", false);
					} else {

						if (isInIframe() && !isMainIframe()) {
							window.parent.loadPossibleUnits();
							window.parent.closeIframe();
						} else {
							$('#divResult').html('');
							$('input, select, textarea').removeClass('is-invalid');
							$("#idSubmit").prop("disabled", false);
							var url = '<?= $_SERVER['PHP_SELF'] ?>';
							$(location).prop('href', url);
						}
						return false;
					}
				});
				return false;
			});

			$('#idBtIncluir').on("click", function() {
				$('#idLoad').css('display', 'block');
				var url = '<?= $_SERVER['PHP_SELF'] ?>?action=new';
				$(location).prop('href', url);
			});

			$('#bt-cancel').on('click', function() {
				var url = '<?= $_SERVER['PHP_SELF'] ?>';
				$(location).prop('href', url);
			});
		});

		function confirmDeleteModal(id) {
			$('#deleteModal').modal();
			$('#deleteButton').html('<a class="btn btn-danger" onclick="deleteData(' + id + ')"><?= TRANS('REMOVE'); ?></a>');
		}

		function deleteData(id) {

			var loading = $(".loading");
			$(document).ajaxStart(function() {
				loading.show();
			});
			$(document).ajaxStop(function() {
				loading.hide();
			});

			$.ajax({
				url: './tech_levels_process.php',
				method: 'POST',
				data: {
					cod: id,
					action: 'delete'
				},
				dataType: 'json',
			}).done(function(response) {
				
				if (!response.success) {
					$('#deleteModal').modal('hide');
					$('#divResult').html(response.message);
					return false;
				}
				
				var url = '<?= $_SERVER['PHP_SELF'] ?>';
				$(location).prop('href', url);
				return false;
			});
			return false;
		}

		function isInIframe() {
			return (window.location !== window.parent.location) ? true : false;
		}

		function isMainIframe() {
			var iframeParent = window.parent.document.getElementById('iframeMain');
			return (iframeParent) ? true : false;
		}
	</script>
</body>

</html>