<?php session_start();
/*      Copyright 2023 Flávio Ribeiro

        This file is part of OCOMON.

        OCOMON is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 3 of the License, or
        (at your option) any later version.
        OCOMON is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with Foobar; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

if (!isset($_SESSION['s_logado']) || $_SESSION['s_logado'] == 0) {
    $_SESSION['session_expired'] = 1;
    echo "<script>top.window.location = '../../index.php'</script>";
    exit;
}

require_once __DIR__ . "/" . "../../includes/include_basics_only.php";
require_once __DIR__ . "/" . "../../includes/classes/ConnectPDO.php";

use includes\classes\ConnectPDO;

$conn = ConnectPDO::getInstance();

$post = $_POST;

$html = "";
$exception = "";
$data = [];
$data['success'] = true;
$data['message'] = "";

$data['random'] = (isset($post['random']) ? noHtml($post['random']) : "");
$data['author'] = $_SESSION['s_uid'];

$authorArea = $_SESSION['s_area'];

$afterDomClass = "after-dom-ready";
$randomClass = $data['random'];
?>
    <div class="form-group col-md-2 <?= $randomClass; ?> <?= $afterDomClass; ?>">
        <div class="subticket_wrapper_fields" id="subticket_wrapper_fields">
            <div class="input-group input-group-sm">
                <div class="input-group-prepend">
                    <div class="input-group-text">
                        <a href="javascript:void(0);" class="remove_button_subticket" data-random="<?= $randomClass; ?>" title="<?= TRANS('REMOVE'); ?>"><i class="fa fa-minus"></i></a>
                    </div>
                </div>
                
                <select class="form-control form-control-sm bs-select" id="sub_requester_<?= $randomClass; ?>" name="sub_requester[]">
                    <option value=""><?= TRANS('REQUESTER'); ?></option>
                    <?php
                        $requesters = getUsers($conn, null, [1,2,3]);
                        foreach ($requesters as $requester) {
                            
                            if (empty($requester['nome'])) {
                                continue;
                            }
                            ?>
                            <option value="<?= $requester['user_id']; ?>"
                            <?=($_SESSION['s_uid'] == $requester['user_id'] ? ' selected' : '');
                            ?>
                            ><?= $requester['nome']; ?></option>
                            <?php
                        }
                    ?>
                </select>
            </div>
            <small class="form-text text-muted"><?= TRANS('REQUESTER'); ?></small>
        </div>
    </div>
    <div class="form-group col-md-2 <?= $randomClass; ?> <?= $afterDomClass; ?>">
        <div class="subticket_wrapper_fields">
            <select class="form-control form-control-sm bs-select" id="sub_operator_<?= $randomClass; ?>" name="sub_operator[]">
                <option value=""><?= TRANS('WORKER'); ?></option>
                <?php
                    $workers = getUsers($conn, null, [1,2]);
                    foreach ($workers as $worker) {
                        if (empty($worker['nome'])) {
                            continue;
                        }
                        ?>
                        <option value="<?= $worker['user_id']; ?>"
                        <?=($_SESSION['s_uid'] == $worker['user_id'] ? ' selected' : '');
                        ?>
                        ><?= $worker['nome']; ?></option>
                        <?php
                    }
                ?>
            </select>
            <small class="form-text text-muted"><?= TRANS('WORKER'); ?></small>
        </div>
    </div>
    <div class="form-group col-md-2 <?= $randomClass; ?> <?= $afterDomClass; ?>">
        <div class="subticket_wrapper_fields" >
            <select class="form-control form-control-sm bs-select row-added-weight" id="sub_issue_type_<?= $randomClass; ?>" name="sub_issue_type[]">
                <option value=""><?= TRANS('ISSUE_TYPE'); ?></option>
                <?php
                    
                    $possibleIssues = getIssuesByArea4($conn, false, $authorArea, 0);
                    
                    foreach ($possibleIssues as $issue) {
                        
                        if (empty($issue['problema'])) {
                            continue;
                        }
                        $subtext = TRANS('WEIGHT'). ': ' . (!empty($issue['weight']) ? $issue['weight'] : TRANS('MSG_NOT_DEFINED'));
                        $issueWeight = (!empty($issue['weight']) ? $issue['weight'] : 1);
                        ?>
                        <option data-subtext="<?= $subtext; ?>" data-weight="<?= $issueWeight; ?>" data-random="<?= $randomClass; ?>" value="<?= $issue['prob_id']; ?>"><?= $issue['problema']; ?></option>
                        <?php
                    }
                ?>
            </select>
            <small class="form-text text-muted"><?= TRANS('ISSUE_TYPE'); ?></small>
        </div>
    </div>
    <div class="form-group col-md-2 <?= $randomClass; ?> <?= $afterDomClass; ?>">
        <div class="subticket_wrapper_fields">
            <select class="form-control form-control-sm bs-select row-added-weight" id="sub_complexity_factor_<?= $randomClass; ?>" name="sub_complexity_factor[]">
                <option value=""><?= TRANS('COMPLEXITY_FACTOR'); ?></option>
                <?php
                    $complexityFactors = getComplexityFactors($conn);
                    foreach ($complexityFactors as $factor) {
                        ?>
                        <option data-subtext="x<?= $factor['factor']; ?>" data-weight="<?= $factor['factor']; ?>" data-random="<?= $randomClass; ?>" value="<?= $factor['id']; ?>"><?= $factor['name']; ?></option>
                        <?php
                    }
                ?>
            </select>
            <small class="form-text text-muted"><?= TRANS('COMPLEXITY_FACTOR'); ?></small>
        </div>
    </div>
    <div class="form-group col-md-2 <?= $randomClass; ?> <?= $afterDomClass; ?>">
        <div class="subticket_wrapper_fields">
            <select class="form-control form-control-sm bs-select row-added-weight" id="sub_impact_factor_<?= $randomClass; ?>" name="sub_impact_factor[]">
                <option value=""><?= TRANS('IMPACT_FACTOR'); ?></option>
                <?php
                    $impactFactors = getImpactFactors($conn);
                    foreach ($impactFactors as $factor) {
                        ?>
                        <option data-subtext="x<?= $factor['factor']; ?>" data-weight="<?= $factor['factor']; ?>" data-random="<?= $randomClass; ?>" value="<?= $factor['id']; ?>"><?= $factor['name']; ?></option>
                        <?php
                    }
                ?>
            </select>
            <small class="form-text text-muted"><?= TRANS('IMPACT_FACTOR'); ?></small>
        </div>
    </div>
    <div class="form-group col-md-2 <?= $randomClass; ?> <?= $afterDomClass; ?>">
        <div class="subticket_wrapper_fields">
            <select class="form-control form-control-sm bs-select row-added-weight" id="sub_deflator_factor_<?= $randomClass; ?>" name="sub_deflator_factor[]">
                <option value=""><?= TRANS('DEFLATOR_FACTOR'); ?></option>
                <?php
                    $deflatorFactors = getDeflatorFactors($conn);
                    foreach ($deflatorFactors as $factor) {
                        ?>
                        <option data-subtext="x<?= $factor['factor']; ?>" data-weight="<?= $factor['factor']; ?>" data-random="<?= $randomClass; ?>" value="<?= $factor['id']; ?>"><?= $factor['name']; ?></option>
                        <?php
                    }
                ?>
            </select>
            <small class="form-text text-muted"><?= TRANS('DEFLATOR_FACTOR'); ?></small>
        </div>
    </div>
    <!-- <input type="hidden" name="new_added_subticket[]" class="row-added-weight" value="0"> -->
<?php
